/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.api.NormalOcclusionTest;
import codechicken.multipart.api.part.IModelRenderPart;
import codechicken.multipart.api.part.IconHitEffects;
import codechicken.multipart.api.part.TIconHitEffectsPart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TNormalOcclusionPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class McStatePart
extends TMultiPart
implements TNormalOcclusionPart,
IModelRenderPart,
TIconHitEffectsPart {
    public BlockState state;

    public McStatePart() {
        this.state = this.defaultBlockState();
    }

    public McStatePart(BlockState state) {
        this.state = state;
    }

    public abstract BlockState defaultBlockState();

    public abstract ItemStack getDropStack();

    @Override
    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.getDropStack());
    }

    @Override
    public ItemStack pickItem(PartRayTraceResult hit) {
        return this.getDropStack();
    }

    @Override
    public void save(CompoundNBT tag) {
        tag.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
    }

    @Override
    public void load(CompoundNBT tag) {
        this.state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("state"));
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeCompoundNBT(NBTUtil.func_190009_a((BlockState)this.state));
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.state = NBTUtil.func_190008_d((CompoundNBT)packet.readCompoundNBT());
    }

    @Override
    public boolean canRenderInLayer(RenderType layer) {
        return RenderTypeLookup.canRenderInLayer((BlockState)this.state, (RenderType)layer);
    }

    @Override
    public BlockState getCurrentState() {
        return this.state;
    }

    @Override
    public IModelData getModelData() {
        return EmptyModelData.INSTANCE;
    }

    public TMultiPart setStateOnPlacement(BlockItemUseContext context) {
        this.state = this.defaultBlockState().func_177230_c().func_196258_a(context);
        return this;
    }

    @Override
    public float getStrength(PlayerEntity player, PartRayTraceResult hit) {
        return this.state.func_185903_a(player, (IBlockReader)player.field_70170_p, new BlockPos(0, -1, 0));
    }

    @Override
    public int getLightValue() {
        return this.state.func_185906_d();
    }

    @Override
    public VoxelShape getShape(ISelectionContext context) {
        return this.state.func_215700_a((IBlockReader)this.world(), this.pos(), context);
    }

    @Override
    public VoxelShape getCollisionShape(ISelectionContext context) {
        return this.state.func_215685_b((IBlockReader)this.world(), this.pos(), context);
    }

    @Override
    public VoxelShape getRenderOcclusionShape() {
        return this.state.func_235754_c_((IBlockReader)this.world(), this.pos());
    }

    @Override
    public VoxelShape getInteractionShape() {
        return this.state.func_235777_m_((IBlockReader)this.world(), this.pos());
    }

    @Override
    public VoxelShape getOcclusionShape() {
        return this.state.func_196952_d(null, null);
    }

    @Override
    public VoxelShape getBlockSupportShape() {
        return this.state.func_196951_e((IBlockReader)this.world(), this.pos());
    }

    @Override
    public VoxelShape getVisualShape(ISelectionContext context) {
        return this.state.func_199611_f((IBlockReader)this.world(), this.pos(), context);
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.test(this, npart);
    }

    @Override
    public SoundType getPlacementSound(ItemUseContext context) {
        return this.state.getSoundType((IWorldReader)this.world(), this.pos(), (Entity)context.func_195999_j());
    }

    @Override
    public Cuboid6 getBounds() {
        return new Cuboid6(this.getShape(ISelectionContext.func_216377_a()).func_197752_a());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return this.getBrokenIcon(hit.func_216354_b().ordinal());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(this.getCurrentState()).getParticleTexture(this.getModelData());
    }

    @Override
    public void addHitEffects(PartRayTraceResult hit, ParticleManager manager) {
        IconHitEffects.addHitEffects(this, hit, manager);
    }

    @Override
    public void addDestroyEffects(PartRayTraceResult hit, ParticleManager manager) {
        IconHitEffects.addDestroyEffects(this, manager, true);
    }
}

