/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.multilayer;

import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.mixin.accessors.client.RenderTypeAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class BakedMultiLayerModel
extends BakedIEModel {
    private final Map<String, IBakedModel> models;
    private final IBakedModel model;

    public BakedMultiLayerModel(Map<String, IBakedModel> models) {
        RenderType[] preferences;
        this.models = models;
        for (RenderType layer : preferences = new RenderType[]{RenderType.func_228639_c_(), RenderType.func_228643_e_(), RenderType.func_228641_d_(), RenderType.func_228645_f_()}) {
            String name = ((RenderTypeAccess)layer).getName();
            if (!models.containsKey(name)) continue;
            this.model = models.get(name);
            return;
        }
        throw new IllegalArgumentException("Can't create multi layer model without any submodels");
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType current = MinecraftForgeClient.getRenderLayer();
        if (current == null) {
            ImmutableList.Builder ret = new ImmutableList.Builder();
            for (IBakedModel model : this.models.values()) {
                ret.addAll((Iterable)model.func_200117_a(state, side, rand));
            }
            return ret.build();
        }
        String name = ((RenderTypeAccess)current).getName();
        if (this.models.containsKey(name)) {
            ImmutableList.Builder ret = new ImmutableList.Builder();
            ret.addAll((Iterable)this.models.get(name).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            return ret.build();
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.model.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.model.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.model.func_188617_f();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        this.model.handlePerspective(cameraTransformType, mat);
        return this;
    }
}

