/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RefineryTileEntity
extends PoweredMultiblockTileEntity<RefineryTileEntity, RefineryRecipe>
implements IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public static final int OUTPUT_EMPTY = 4;
    public static final int OUTPUT_FILLED = 5;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000), new FluidTank(24000), new FluidTank(24000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(RefineryTileEntity::getShape);
    private static final BlockPos outputOffset = new BlockPos(2, 0, 2);
    private static final Set<BlockPos> inputOffsets = ImmutableSet.of((Object)new BlockPos(0, 0, 1), (Object)new BlockPos(4, 0, 1));

    public RefineryTileEntity() {
        super(IEMultiblocks.REFINERY, 16000, true, (TileEntityType)IETileTypes.REFINERY.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 6);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank2", (INBT)this.tanks[2].writeToNBT(new CompoundNBT()));
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void func_73660_a() {
        RefineryRecipe recipe;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.isDummy()) {
            return;
        }
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (this.tanks[0].getFluidAmount() > 0 || this.tanks[1].getFluidAmount() > 0) && (recipe = RefineryRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) != null) {
            int[] nArray;
            PoweredMultiblockTileEntity.MultiblockProcessInMachine<RefineryRecipe> multiblockProcessInMachine = new PoweredMultiblockTileEntity.MultiblockProcessInMachine<RefineryRecipe>(recipe, new int[0]);
            if (this.tanks[0].getFluidAmount() > 0 && this.tanks[1].getFluidAmount() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else if (this.tanks[0].getFluidAmount() > 0) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            } else {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 1;
            }
            PoweredMultiblockTileEntity.MultiblockProcessInMachine<RefineryRecipe> process = multiblockProcessInMachine.setInputTanks(nArray);
            if (this.addProcessToQueue(process, true)) {
                this.addProcessToQueue(process, false);
                update = true;
            }
        }
        Direction fw = this.getFacing().func_176734_d();
        update |= FluidUtils.multiblockFluidOutput(this.field_145850_b, this.func_174877_v().func_177982_a(0, -1, 0).func_177972_a(fw), fw, this.tanks[2], 4, 5, arg_0 -> this.inventory.get(arg_0), (arg_0, arg_1) -> this.inventory.set(arg_0, arg_1));
        for (int tank = 0; tank < 2; ++tank) {
            int inputSlot = 2 * tank;
            int outputSlot = inputSlot + 1;
            int amountPrev = this.tanks[tank].getFluidAmount();
            ItemStack outputStack = (ItemStack)this.inventory.get(outputSlot);
            ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[tank], (ItemStack)this.inventory.get(inputSlot), outputStack);
            if (amountPrev == this.tanks[tank].getFluidAmount()) continue;
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)emptyContainer)) {
                outputStack.func_190917_f(emptyContainer.func_190916_E());
            } else if (outputStack.func_190926_b()) {
                this.inventory.set(outputSlot, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(inputSlot)).func_190918_g(outputSlot);
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.func_177952_p() % 2 == 0 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177958_n() % 4 == 0) {
            List<AxisAlignedBB> list = Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 0, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.25, 0.5, 0.0, 0.5, 1.375, 0.25));
            if (new BlockPos(4, 0, 2).equals((Object)posInMultiblock)) {
                list.add(new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
                list.add(new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            }
            return list;
        }
        if (posInMultiblock.func_177952_p() % 2 == 0 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177958_n() % 2 == 1) {
            return Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 1, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 0.25, 1.375, 0.25));
        }
        if (posInMultiblock.func_177952_p() < 2 && posInMultiblock.func_177956_o() > 0 && posInMultiblock.func_177958_n() % 4 == 0) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.func_177956_o() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.func_177956_o() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.func_177952_p() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 4, new AxisAlignedBB(0.5, (double)minY, (double)minZ, 2.0, (double)maxY, (double)maxZ));
        }
        if (posInMultiblock.func_177952_p() < 2 && posInMultiblock.func_177956_o() > 0 && posInMultiblock.func_177958_n() % 2 == 1) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.func_177956_o() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.func_177956_o() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.func_177952_p() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 3, new AxisAlignedBB(-0.5, (double)minY, (double)minZ, 1.0, (double)maxY, (double)maxZ));
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(3, 0, 2)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(4, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 0));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(4, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<RefineryRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<RefineryRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 1;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<RefineryRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{2};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        RefineryTileEntity master = (RefineryTileEntity)this.master();
        if (master != null) {
            if (outputOffset.equals((Object)this.posInMultiblock) && (side == null || side == this.getFacing().func_176734_d())) {
                return new FluidTank[]{master.tanks[2]};
            }
            if (inputOffsets.contains(this.posInMultiblock) && (side == null || side.func_176740_k() == this.getFacing().func_176735_f().func_176740_k())) {
                return new FluidTank[]{master.tanks[0], master.tanks[1]};
            }
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        if (inputOffsets.contains(this.posInMultiblock) && (side == null || side.func_176740_k() == this.getFacing().func_176735_f().func_176740_k())) {
            RefineryTileEntity master = (RefineryTileEntity)this.master();
            if (master == null || master.tanks[iTank].getFluidAmount() >= master.tanks[iTank].getCapacity()) {
                return false;
            }
            if (master.tanks[0].getFluid().isEmpty() && master.tanks[1].getFluid().isEmpty()) {
                Optional<RefineryRecipe> incompleteRecipes = RefineryRecipe.findIncompleteRefineryRecipe(resource, FluidStack.EMPTY);
                return incompleteRecipes.isPresent();
            }
            FluidStack otherFluid = master.tanks[iTank == 0 ? 1 : 0].getFluid();
            Optional<RefineryRecipe> incompleteRecipes = RefineryRecipe.findIncompleteRefineryRecipe(resource, otherFluid);
            return incompleteRecipes.isPresent();
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return outputOffset.equals((Object)this.posInMultiblock) && (side == null || side == this.getFacing().func_176734_d());
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public RefineryRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected RefineryRecipe getRecipeForId(ResourceLocation id) {
        return RefineryRecipe.recipeList.get(id);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }
}

