/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class AbstractFluidAwareRecipe<MatchLocation extends IMatchLocation>
implements ICraftingRecipe {
    protected static final boolean[] BOOLEANS = new boolean[]{true, false};
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final String group;

    public AbstractFluidAwareRecipe(ResourceLocation idIn, String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        return this.findMatch(inv) != null;
    }

    @Nullable
    protected abstract MatchLocation findMatch(CraftingInventory var1);

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingInventory inv) {
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        MatchLocation offset = this.findMatch(inv);
        if (offset == null) {
            IELogger.logger.error("IRecipe#getRemainingItems was called with an inventory that does not match the recipe");
            IELogger.logger.error("according to IRecipe#matches. This is probably a bug in some mod in the following stacktrace,");
            IELogger.logger.error("if in doubt report it to Immersive Engineering", (Throwable)new IllegalArgumentException());
            return super.func_179532_b((IInventory)inv);
        }
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                int invIndex = this.getInventoryIndex(inv, x, y);
                int ingrIndex = offset.getListIndex(x, y);
                if (ingrIndex < 0 || ingrIndex >= this.func_192400_c().size()) continue;
                Ingredient ingr = (Ingredient)this.func_192400_c().get(ingrIndex);
                ItemStack item = inv.func_70301_a(invIndex);
                ItemStack result = ItemStack.field_190927_a;
                if (ingr instanceof IngredientFluidStack) {
                    result = ((IngredientFluidStack)ingr).getExtractedStack(item.func_77946_l());
                } else if (item.hasContainerItem()) {
                    result = item.getContainerItem();
                }
                if (result == item) {
                    result = result.func_77946_l();
                }
                remaining.set(invIndex, (Object)result);
            }
        }
        return remaining;
    }

    private int getInventoryIndex(CraftingInventory inv, int x, int y) {
        return x + y * inv.func_174922_i();
    }

    public static interface IMatchLocation {
        public int getListIndex(int var1, int var2);
    }
}

