/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class IETileSound
implements ITickableSound {
    protected Sound sound;
    private SoundEventAccessor soundEvent;
    private SoundCategory category;
    public ISound.AttenuationType attenuation;
    public final ResourceLocation resource;
    public float volume;
    public float pitch;
    public int tileX;
    public int tileY;
    public int tileZ;
    public boolean canRepeat;
    public int repeatDelay;
    public float volumeAjustment = 1.0f;
    public float[] origPos;
    public boolean donePlaying = false;

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, x, y, z, attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this.attenuation = attenuation;
        this.resource = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
        this.canRepeat = repeat;
        this.repeatDelay = repeatDelay;
        this.origPos = new float[]{x, y, z};
        this.category = category;
    }

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(sound, volume, pitch, repeat, repeatDelay, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attenuation, category);
    }

    public ISound.AttenuationType func_147656_j() {
        return this.attenuation;
    }

    public ResourceLocation func_147650_b() {
        return this.resource;
    }

    @Nullable
    public SoundEventAccessor func_184366_a(SoundHandler handler) {
        this.soundEvent = handler.func_184398_a(this.resource);
        this.sound = this.soundEvent == null ? SoundHandler.field_147700_a : this.soundEvent.func_148720_g();
        return this.soundEvent;
    }

    public Sound func_184364_b() {
        return this.sound;
    }

    public SoundCategory func_184365_d() {
        return this.category;
    }

    public float func_147653_e() {
        return this.volume * this.volumeAjustment;
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public double func_147649_g() {
        return this.tileX;
    }

    public double func_147654_h() {
        return this.tileY;
    }

    public double func_147651_i() {
        return this.tileZ;
    }

    public boolean func_147657_c() {
        return this.canRepeat;
    }

    public boolean func_217861_m() {
        return false;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }

    public void evaluateVolume() {
        TileEntity tile;
        ItemStack earmuffs;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().field_71439_g != null && !(earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)ClientUtils.mc().field_71439_g)).func_190926_b()) {
            this.volumeAjustment = EarmuffsItem.getVolumeMod(earmuffs);
        }
        if (!((tile = ClientUtils.mc().field_71439_g.field_70170_p.func_175625_s(new BlockPos(this.tileX, this.tileY, this.tileZ))) instanceof IEBlockInterfaces.ISoundTile)) {
            this.donePlaying = true;
        } else {
            boolean bl = this.donePlaying = !((IEBlockInterfaces.ISoundTile)tile).shouldPlaySound(this.resource.toString());
            if (!this.donePlaying) {
                float radiusSq = ((IEBlockInterfaces.ISoundTile)tile).getSoundRadiusSq();
                if (ClientUtils.mc().field_71439_g != null) {
                    double distSq = ClientUtils.mc().field_71439_g.func_70092_e((double)this.tileX, (double)this.tileY, (double)this.tileZ);
                    if (distSq > (double)radiusSq) {
                        this.donePlaying = true;
                    } else {
                        this.volumeAjustment = (float)((double)this.volumeAjustment * (((double)radiusSq - distSq) / (double)radiusSq));
                    }
                }
            }
        }
    }

    public void func_73660_a() {
        if (ClientUtils.mc().field_71439_g != null && ClientUtils.mc().field_71439_g.field_70170_p.func_82737_E() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }
}

