/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import malte0811.modelsplitter.math.ModelSplitterVec3i;

public class Vec3d {
    public static final Vec3d ZERO = new Vec3d(0.0, 0.0, 0.0);
    private final double[] elements;

    public Vec3d(double[] data) {
        Preconditions.checkArgument((data.length == 3 ? 1 : 0) != 0);
        for (int i = 0; i < 3; ++i) {
            Preconditions.checkArgument((boolean)Double.isFinite(data[i]));
        }
        this.elements = Arrays.copyOf(data, 3);
    }

    public Vec3d(double x, double y, double z) {
        this(new double[]{x, y, z});
    }

    public Vec3d(ModelSplitterVec3i vec) {
        this(vec.getX(), vec.getY(), vec.getZ());
    }

    public double dotProduct(Vec3d other) {
        double ret = 0.0;
        for (int i = 0; i < 3; ++i) {
            ret += this.get(i) * other.get(i);
        }
        return ret;
    }

    public double get(int index) {
        return this.elements[index];
    }

    public double lengthSquared() {
        double ret = 0.0;
        for (int i = 0; i < 3; ++i) {
            ret += this.get(i) * this.get(i);
        }
        return ret;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Vec3d scale(double lambda) {
        return new Vec3d(this.get(0) * lambda, this.get(1) * lambda, this.get(2) * lambda);
    }

    public Vec3d add(Vec3d other) {
        return new Vec3d(this.get(0) + other.get(0), this.get(1) + other.get(1), this.get(2) + other.get(2));
    }

    public Vec3d subtract(Vec3d other) {
        return new Vec3d(this.get(0) - other.get(0), this.get(1) - other.get(1), this.get(2) - other.get(2));
    }

    public String toString() {
        return this.get(0) + " " + this.get(1) + " " + this.get(2);
    }

    public Vec3d normalize() {
        double len = this.length();
        if (len < 1.0E-4) {
            return this;
        }
        return this.scale(1.0 / len);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3d vec3d = (Vec3d)o;
        return Arrays.equals(this.elements, vec3d.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }
}

