/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import fuzs.diagonalfences.api.IDiagonalBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import xfacthd.framedblocks.client.model.FramedFenceModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedDiagonalFenceModel
extends FramedFenceModel {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;

    public FramedDiagonalFenceModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        boolean hasProps = state.func_177230_c() instanceof IDiagonalBlock && ((IDiagonalBlock)state.func_177230_c()).hasProperties();
        this.northEast = hasProps && (Boolean)state.func_177229_b((Property)IDiagonalBlock.NORTH_EAST) != false;
        this.southEast = hasProps && (Boolean)state.func_177229_b((Property)IDiagonalBlock.SOUTH_EAST) != false;
        this.northWest = hasProps && (Boolean)state.func_177229_b((Property)IDiagonalBlock.NORTH_WEST) != false;
        this.southWest = hasProps && (Boolean)state.func_177229_b((Property)IDiagonalBlock.SOUTH_WEST) != false;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        this.createDiagonalFenceBars(quadMap, quad, Direction.NORTH, this.northEast);
        this.createDiagonalFenceBars(quadMap, quad, Direction.EAST, this.southEast);
        this.createDiagonalFenceBars(quadMap, quad, Direction.SOUTH, this.southWest);
        this.createDiagonalFenceBars(quadMap, quad, Direction.WEST, this.northWest);
    }

    private void createDiagonalFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (active) {
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176734_d(), 0.4375f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176746_e(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176735_f(), 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.9375f : 0.25f);
                    this.rotateQuad(topBotQuad, dir);
                    quadMap.get(null).add(topBotQuad);
                    topBotQuad = ModelUtils.duplicateQuad(topBotQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.5625f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else if (quad.func_178210_d() == dir.func_176746_e() || quad.func_178210_d() == dir.func_176735_f()) {
                boolean neg = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, neg ? 0.0f : 0.5625f, 0.375f, neg ? 0.4375f : 1.0f, 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    this.rotateQuad(sideQuad, dir);
                    quadMap.get(null).add(sideQuad);
                }
                if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), neg ? 0.0f : 0.5625f, 0.75f, neg ? 0.4375f : 1.0f, 0.9375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    this.rotateQuad(sideQuad, dir);
                    quadMap.get(null).add(sideQuad);
                }
            } else if (quad.func_178210_d() == dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(frontQuad, 0.4375f, 0.375f, 0.5625f, 0.5625f)) {
                    this.rotateQuad(frontQuad, dir);
                    quadMap.get(null).add(frontQuad);
                }
                if (BakedQuadTransformer.createSideQuad(frontQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.75f, 0.5625f, 0.9375f)) {
                    this.rotateQuad(frontQuad, dir);
                    quadMap.get(null).add(frontQuad);
                }
            }
        }
    }

    private void rotateQuad(BakedQuad quad, Direction dir) {
        BakedQuadTransformer.rotateQuadAroundAxisCentered(quad, Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.func_82601_c(), 1.0f, (float)dir.func_82599_e()));
    }
}

