/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedRailSlopeModel
extends BakedModelProxy {
    private final BlockState slopeState;
    private final BlockState railState;
    private IBakedModel slopeModel = null;
    private IBakedModel railModel = null;

    public FramedRailSlopeModel(BlockState state, IBakedModel baseModel) {
        super(baseModel);
        RailShape shape = (RailShape)state.func_177229_b(PropertyHolder.ASCENDING_RAIL_SHAPE);
        Direction dir = FramedRailSlopeBlock.directionFromShape(shape);
        this.slopeState = (BlockState)((Block)FBContent.blockFramedSlope.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
        this.railState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208165_R, (Comparable)shape);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getSlopeQuads(side, rand, extraData));
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == RenderType.func_228643_e_() || layer == null) {
            quads.addAll(this.getRailQuads(side, rand));
        }
        return quads;
    }

    @Override
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return te.getModelData();
        }
        return tileData;
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getSlopeModel().getParticleTexture(data);
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.getSlopeModel().func_177554_e();
    }

    private IBakedModel getSlopeModel() {
        if (this.slopeModel == null) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            this.slopeModel = dispatcher.func_184389_a(this.slopeState);
        }
        return this.slopeModel;
    }

    private List<BakedQuad> getSlopeQuads(@Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getSlopeModel().getQuads(this.slopeState, side, rand, extraData);
    }

    private List<BakedQuad> getRailQuads(@Nullable Direction side, Random rand) {
        if (this.railModel == null) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            this.railModel = dispatcher.func_184389_a(this.railState);
        }
        return this.railModel.getQuads(this.railState, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedRailSlope.get()).func_176223_P().func_206870_a(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }
}

