/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.client.util.TriangleDirection;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction orientation;

    public FramedSlopedPrismModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        this.orientation = (Direction)state.func_177229_b((Property)PropertyHolder.ORIENTATION);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.isStateInvalid()) {
            quadMap.get(quad.func_178210_d()).add(quad);
            return;
        }
        Direction quadFace = quad.func_178210_d();
        if (quadFace == this.orientation.func_176734_d() && this.orientation.func_176740_k() != Direction.Axis.Y) {
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (this.facing.func_176740_k() == Direction.Axis.Y) {
                TriangleDirection triDir;
                TriangleDirection triangleDirection = triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
                if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(triangle, this.facing == Direction.UP);
                    quadMap.get(null).add(triangle);
                }
            } else {
                TriangleDirection triDir;
                TriangleDirection triangleDirection = triDir = this.orientation == this.facing.func_176735_f() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
                if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                    BakedQuadTransformer.createSideSlopeQuad(triangle, triDir == TriangleDirection.RIGHT);
                    quadMap.get(null).add(triangle);
                }
            }
        } else if (quadFace == this.facing && this.orientation.func_176740_k() == Direction.Axis.Y) {
            TriangleDirection triDir = this.orientation == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(triangle, this.orientation == Direction.DOWN);
                quadMap.get(null).add(triangle);
            }
        } else if (quadFace == this.orientation) {
            TriangleDirection triDir;
            if (this.facing.func_176740_k() == Direction.Axis.Y) {
                triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            } else if (this.orientation.func_176740_k() != Direction.Axis.Y) {
                triDir = quadFace == this.facing.func_176746_e() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
            } else {
                BakedQuad triangle = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomSmallTriangleQuad(triangle, this.facing)) {
                    quadMap.get(quadFace).add(triangle);
                }
                return;
            }
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                quadMap.get(quadFace).add(triangle);
            }
        } else if (this.facing.func_176740_k() == Direction.Axis.Y && quadFace.func_176740_k() != this.facing.func_176740_k() && quadFace.func_176740_k() != this.orientation.func_176740_k()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.facing == Direction.DOWN, 0.5f)) {
                BakedQuad corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, quadFace == this.orientation.func_176746_e(), this.facing == Direction.DOWN)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, this.facing == Direction.UP);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.func_176734_d(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, this.facing == Direction.UP);
                    quadMap.get(null).add(slope);
                }
            }
        } else if (this.orientation.func_176740_k() == Direction.Axis.Y && quadFace.func_176740_k() != this.facing.func_176740_k() && quadFace.func_176740_k() != this.orientation.func_176740_k()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(slope, this.facing, 0.5f)) {
                BakedQuad corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createHorizontalSideQuad(corner, this.orientation == Direction.DOWN, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, quadFace == this.facing.func_176735_f(), this.orientation == Direction.UP)) {
                    BakedQuadTransformer.createSideSlopeQuad(corner, quadFace == this.facing.func_176746_e());
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.orientation == Direction.UP, 0.5f)) {
                    BakedQuadTransformer.createSideSlopeQuad(slope, quadFace == this.facing.func_176746_e());
                    quadMap.get(null).add(slope);
                }
            }
        } else if (this.orientation.func_176740_k() != Direction.Axis.Y && this.facing.func_176740_k() != Direction.Axis.Y && quadFace == this.facing) {
            BakedQuad corner;
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, false, 0.5f)) {
                corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, this.orientation == this.facing.func_176735_f(), false)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, false);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.func_176734_d(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, false);
                    quadMap.get(null).add(slope);
                }
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(slope = ModelUtils.duplicateQuad(quad), true, 0.5f)) {
                corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, this.orientation == this.facing.func_176735_f(), true)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, true);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.func_176734_d(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, true);
                    quadMap.get(null).add(slope);
                }
            }
        }
    }

    private boolean isStateInvalid() {
        return this.orientation.func_176740_k() == this.facing.func_176740_k();
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedSlopedPrism.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP)).func_206870_a((Property)PropertyHolder.ORIENTATION, (Comparable)Direction.WEST);
    }
}

