/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import xfacthd.framedblocks.client.render.outline.OutlineRender;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedCollapsibleTileEntity;

public class CollapsibleBlockOutlineRenderer
implements OutlineRender {
    private static final Quaternion ROTATION = Vector3f.field_229180_c_.func_229187_a_(180.0f);

    @Override
    public void rotateMatrix(MatrixStack mstack, BlockState state) {
        mstack.func_227863_a_(ROTATION);
    }

    @Override
    public void draw(BlockState state, World world, BlockPos pos, MatrixStack mstack, IVertexBuilder builder) {
        CollapseFace face = (CollapseFace)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE));
        if (face == CollapseFace.NONE) {
            VoxelShapes.func_197868_b().func_197754_a((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> OutlineRender.drawLine(builder, mstack, pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ));
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FramedCollapsibleTileEntity)) {
                return;
            }
            byte[] offets = ((FramedCollapsibleTileEntity)te).getVertexOffsets();
            Direction faceDir = face.toDirection().func_176734_d();
            mstack.func_227860_a_();
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (faceDir == Direction.UP) {
                mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            } else if (faceDir != Direction.DOWN) {
                mstack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(faceDir.func_185119_l() + 180.0f));
                mstack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            mstack.func_227865_b_();
        }
    }

    @Override
    public void draw(BlockState state, MatrixStack poseStack, IVertexBuilder builder) {
        throw new UnsupportedOperationException();
    }
}

