/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;

public abstract class AbstractFramedSignBlock
extends FramedBlock {
    protected AbstractFramedSignBlock(BlockType type, AbstractBlock.Properties props) {
        super(type, props);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean dye;
        ActionResultType result = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (result != ActionResultType.PASS) {
            return result;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = dye = stack.func_77973_b() instanceof DyeItem && player.field_71075_bZ.field_75099_e;
        if (world.field_72995_K) {
            return dye ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedSignTileEntity) {
            FramedSignTileEntity sign = (FramedSignTileEntity)te;
            if (dye) {
                boolean success = sign.setTextColor(((DyeItem)stack.func_77973_b()).func_195962_g());
                if (success && !player.func_184812_l_()) {
                    stack.func_190918_g(1);
                    player.field_71071_by.func_70296_d();
                }
                if (success) {
                    return ActionResultType.SUCCESS;
                }
            } else if (sign.executeCommand((ServerPlayerEntity)player)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(world, pos, placer, stack);
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type != PathType.WATER || world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedSignTileEntity();
    }

    public boolean func_181623_g() {
        return true;
    }
}

