/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.buildinggadgets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.buildinggadgets.BuildingGadgetsCompat;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.Utils;

class FramedTileEntityData
extends NBTTileEntityData {
    public FramedTileEntityData(FramedTileEntity te) {
        super(te.writeToBlueprint(), FramedTileEntityData.buildMaterialList(te));
    }

    public FramedTileEntityData(CompoundNBT data, MaterialList materials) {
        super(data, materials);
    }

    public boolean placeIn(BuildContext context, BlockState state, BlockPos pos) {
        BuildingGadgets.LOG.trace("Placing {} with Tile NBT at {}.", (Object)state, (Object)pos);
        context.getWorld().func_180501_a(pos, state, 0);
        Utils.enqueueImmediateTask(context.getWorld(), () -> {
            TileEntity te = context.getWorld().func_175625_s(pos);
            if (te != null) {
                CompoundNBT nbt = this.getNBT();
                nbt.func_74768_a("x", pos.func_177958_n());
                nbt.func_74768_a("y", pos.func_177956_o());
                nbt.func_74768_a("z", pos.func_177952_p());
                try {
                    te.func_230337_a_(state, nbt);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Failed to apply Tile NBT Data to {} at {} in Context {}", (Object)state, (Object)pos, (Object)context, (Object)e);
                }
            }
        }, true);
        return true;
    }

    public ITileDataSerializer getSerializer() {
        return (ITileDataSerializer)BuildingGadgetsCompat.FRAMED_SERIALIZER.get();
    }

    private static MaterialList buildMaterialList(FramedTileEntity te) {
        MaterialList.SimpleBuilder builder = MaterialList.simpleBuilder();
        if (te.getBlock() == FBContent.blockFramedDoubleSlab.get()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)FBContent.blockFramedSlab.get())), UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)FBContent.blockFramedSlab.get()))});
        } else if (te.getBlock() == FBContent.blockFramedDoublePanel.get()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)FBContent.blockFramedPanel.get())), UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)FBContent.blockFramedPanel.get()))});
        } else {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)te.func_195044_w().func_177230_c()))});
        }
        if (!te.getCamoState().func_196958_f()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)te.getCamoStack().func_77946_l())});
        }
        if (te instanceof FramedDoubleTileEntity && !((FramedDoubleTileEntity)te).getCamoStateTwo().func_196958_f()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)((FramedDoubleTileEntity)te).getCamoStackTwo().func_77946_l())});
        }
        if (te.isGlowing()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((IItemProvider)Items.field_151114_aO))});
        }
        return builder.build();
    }
}

