/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.vector.Vector3d;
import xfacthd.framedblocks.common.util.Utils;

public enum Rotation implements IStringSerializable
{
    UP(dir -> Direction.UP),
    DOWN(dir -> Direction.DOWN),
    RIGHT(Direction::func_176746_e),
    LEFT(Direction::func_176735_f);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final Function<Direction, Direction> facingMod;

    private Rotation(Function<Direction, Direction> facingMod) {
        this.facingMod = facingMod;
    }

    public Direction withFacing(Direction dir) {
        return this.facingMod.apply(dir);
    }

    public Rotation getOpposite() {
        switch (this) {
            case UP: {
                return DOWN;
            }
            case DOWN: {
                return UP;
            }
            case RIGHT: {
                return LEFT;
            }
            case LEFT: {
                return RIGHT;
            }
        }
        throw new IllegalArgumentException("Invalid rotation");
    }

    public boolean isVertical() {
        return this == UP || this == DOWN;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static Rotation fromDirection(Direction facing, Direction dir) {
        Preconditions.checkArgument((!Utils.isY(facing) ? 1 : 0) != 0, (Object)"View direction must not be on the Y axis");
        Preconditions.checkArgument((facing.func_176740_k() != dir.func_176740_k() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (dir == Direction.UP) {
            return UP;
        }
        if (dir == Direction.DOWN) {
            return DOWN;
        }
        if (dir == facing.func_176746_e()) {
            return RIGHT;
        }
        if (dir == facing.func_176735_f()) {
            return LEFT;
        }
        throw new IllegalStateException(String.format("How did we get here?! %s|%s", facing, dir));
    }

    public static Rotation fromWallCross(Vector3d hitVec, Direction hitFace) {
        hitVec = Utils.fraction(hitVec);
        double xz = (Utils.isX(hitFace) ? hitVec.func_82616_c() : hitVec.func_82615_a()) - 0.5;
        double y = hitVec.func_82617_b() - 0.5;
        if (Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz)) {
            if (Utils.isX(hitFace)) {
                return xz < 0.0 == Utils.isPositive(hitFace) ? LEFT : RIGHT;
            }
            return xz < 0.0 == Utils.isPositive(hitFace) ? RIGHT : LEFT;
        }
        return y < 0.0 ? UP : DOWN;
    }
}

