/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.HydroponicBedConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.registry.IFRegistries;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class HydroponicBedTile
extends IndustrialWorkingTile<HydroponicBedTile> {
    @Save
    private SidedFluidTankComponent<HydroponicBedTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", 1000, 43, 20, 0).setColor(DyeColor.BLUE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a) || fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b));
    @Save
    private SidedFluidTankComponent<HydroponicBedTile> ether;
    @Save
    private ProgressBarComponent<HydroponicBedTile> etherBuffer;
    @Save
    private SidedInventoryComponent<HydroponicBedTile> output;

    public HydroponicBedTile() {
        super(ModuleAgricultureHusbandry.HYDROPONIC_BED, HydroponicBedConfig.powerPerOperation);
        this.addTank(this.water);
        this.ether = (SidedFluidTankComponent)new SidedFluidTankComponent("ether", 10, 43, 57, 1).setColor(DyeColor.CYAN).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.ETHER.getSourceFluid()));
        this.addTank(this.ether);
        this.etherBuffer = new ProgressBarComponent(63, 20, 200).setColor(DyeColor.CYAN).setCanReset(hydroponicBedTile -> false);
        this.addProgressBar(this.etherBuffer);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 79, 22, 15, 2).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.etherBuffer.getProgress() <= 0 && this.ether.getFluidAmount() > 0) {
            this.ether.drainForced(1, IFluidHandler.FluidAction.EXECUTE);
            this.etherBuffer.setProgress(this.etherBuffer.getMaxProgress());
        }
        if (this.hasEnergy(1000)) {
            BlockPos up = this.field_174879_c.func_177984_a();
            BlockState state = this.field_145850_b.func_180495_p(up);
            Block block = state.func_177230_c();
            if (!this.field_145850_b.func_175623_d(up) && this.water.getFluidAmount() >= 10) {
                if (block instanceof IPlantable && ((IPlantable)block).getPlantType((IBlockReader)this.field_145850_b, up) == PlantType.NETHER && !this.water.getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204547_b)) {
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
                }
                if (state.func_177230_c() instanceof IGrowable) {
                    IGrowable growable = (IGrowable)this.field_145850_b.func_180495_p(up).func_177230_c();
                    if (growable.func_176473_a((IBlockReader)this.field_145850_b, up, this.field_145850_b.func_180495_p(up), false)) {
                        if (this.etherBuffer.getProgress() > 0) {
                            growable.func_225535_a_((ServerWorld)this.field_145850_b, this.field_145850_b.field_73012_v, up, this.field_145850_b.func_180495_p(up));
                            this.etherBuffer.setProgress(this.etherBuffer.getProgress() - 1);
                        } else {
                            for (int i = 0; i < 4; ++i) {
                                this.field_145850_b.func_180495_p(up).func_227034_b_((ServerWorld)this.field_145850_b, up, this.field_145850_b.field_73012_v);
                            }
                        }
                        this.water.drainForced(10, IFluidHandler.FluidAction.EXECUTE);
                        return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                    }
                    if (this.etherBuffer.getProgress() > 0) {
                        this.tryToHarvestAndReplant(up, state);
                        return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                    }
                } else {
                    if (!this.tryToHarvestAndReplant(up, state)) {
                        if (this.etherBuffer.getProgress() > 0) {
                            for (int i = 0; i < 10; ++i) {
                                this.field_145850_b.func_180495_p(up).func_227034_b_((ServerWorld)this.field_145850_b, up, this.field_145850_b.field_73012_v);
                            }
                            this.etherBuffer.setProgress(this.etherBuffer.getProgress() - 1);
                        } else {
                            for (int i = 0; i < 4; ++i) {
                                this.field_145850_b.func_180495_p(up).func_227034_b_((ServerWorld)this.field_145850_b, up, this.field_145850_b.field_73012_v);
                            }
                        }
                        this.water.drainForced(10, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                }
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer() && this.field_145850_b.func_82737_E() % 5L == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (!(tile instanceof HydroponicBedTile)) continue;
                int difference = this.water.getFluidAmount() - ((HydroponicBedTile)tile).getWater().getFluidAmount();
                if (difference > 0 && (this.water.getFluid().isFluidEqual(((HydroponicBedTile)tile).getWater().getFluid()) || ((HydroponicBedTile)tile).getWater().isEmpty())) {
                    difference = difference <= 25 ? (difference /= 2) : 25;
                    if (this.water.getFluidAmount() >= difference) {
                        this.water.drainForced(((HydroponicBedTile)tile).getWater().fill(new FluidStack((Fluid)Fluids.field_204546_a, this.water.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.ether.getFluidAmount() - ((HydroponicBedTile)tile).getEther().getFluidAmount()) > 0) {
                    difference = 1;
                    if (this.ether.getFluidAmount() >= difference) {
                        this.ether.drainForced(((HydroponicBedTile)tile).getEther().fill(new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid(), this.ether.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.getEnergyStorage().getEnergyStored() - ((HydroponicBedTile)tile).getEnergyStorage().getEnergyStored()) <= 0) continue;
                if (difference <= 1000 && difference > 1) {
                    difference /= 2;
                }
                if (difference > 1000) {
                    difference = 1000;
                }
                if (this.getEnergyStorage().getEnergyStored() < difference) continue;
                this.getEnergyStorage().extractEnergy(((HydroponicBedTile)tile).getEnergyStorage().receiveEnergy(difference, false), false);
            }
        }
    }

    public SidedFluidTankComponent<HydroponicBedTile> getWater() {
        return this.water;
    }

    public SidedFluidTankComponent<HydroponicBedTile> getEther() {
        return this.ether;
    }

    private boolean tryToHarvestAndReplant(BlockPos up, BlockState state) {
        Optional<PlantRecollectable> optional = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValues().stream().filter(plantRecollectable -> plantRecollectable.canBeHarvested(this.field_145850_b, up, state)).findFirst();
        if (optional.isPresent()) {
            List<ItemStack> drops = optional.get().doHarvestOperation(this.field_145850_b, up, state);
            if (this.field_145850_b.func_175623_d(up)) {
                for (ItemStack drop : drops) {
                    if (drop.func_77973_b() instanceof IPlantable) {
                        this.field_145850_b.func_175656_a(up, ((IPlantable)drop.func_77973_b()).getPlant((IBlockReader)this.field_145850_b, up));
                        drop.func_190918_g(1);
                        break;
                    }
                    if (!(drop.func_77973_b() instanceof BlockItem) || !(((BlockItem)drop.func_77973_b()).func_179223_d() instanceof IPlantable)) continue;
                    this.field_145850_b.func_175656_a(up, ((IPlantable)((BlockItem)drop.func_77973_b()).func_179223_d()).getPlant((IBlockReader)this.field_145850_b, up));
                    drop.func_190918_g(1);
                    break;
                }
            }
            drops.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
            this.etherBuffer.setProgress(this.etherBuffer.getProgress() - 1);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxProgress() {
        return HydroponicBedConfig.maxProgress;
    }

    @Nonnull
    public HydroponicBedTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<HydroponicBedTile> createEnergyStorage() {
        return new EnergyStorageComponent(HydroponicBedConfig.maxStoredPower, 10, 20);
    }
}

