/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ThrowablePotionItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class PotionGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "potion";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.func_77973_b() instanceof PotionItem);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundNBT>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0);
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundNBT>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0) {
            ItemStack calculate = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_77946_l();
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            if (stack.func_190916_E() == 1) {
                ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, new ItemStack((IItemProvider)Items.field_151069_bo));
            } else {
                stack.func_190918_g(1);
            }
            return this.calculate(calculate);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.PURPLE};
    }

    @Override
    public Item getDisplay() {
        return Items.field_151068_bn;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        return ForgeRegistries.POTION_TYPES.getValues().stream().filter(potion -> potion != Potions.field_185229_a).map(effect -> Arrays.asList(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)effect), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)effect), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)effect))).flatMap(Collection::stream).map(stack -> new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)this.calculate((ItemStack)stack).getLeft(), (Integer)this.calculate((ItemStack)stack).getRight())).collect(Collectors.toList());
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        int duration = 80;
        int amplifier = 1;
        for (EffectInstance potionEffect : potion.func_185170_a()) {
            duration += potionEffect.func_76459_b();
            amplifier += potionEffect.func_76458_c();
        }
        double powValue = 2.0;
        if (stack.func_77973_b() instanceof ThrowablePotionItem) {
            powValue = 2.5;
        }
        if (stack.func_77973_b() instanceof LingeringPotionItem) {
            powValue = 3.0;
        }
        return Pair.of((Object)duration, (Object)((int)(Math.pow(amplifier, powValue) * 10.0)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151075_bm).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_150382_bo).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

