/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.generator.BioReactorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BioReactorTile
extends IndustrialWorkingTile<BioReactorTile> {
    public static ITag<Item>[] VALID = new ITag[]{IndustrialTags.Items.BIOREACTOR_INPUT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_NETHER_WART, Tags.Items.DYES, Tags.Items.HEADS, Tags.Items.MUSHROOMS, Tags.Items.SEEDS, ItemTags.field_200037_g};
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<BioReactorTile> biofuel;
    @Save
    private SidedFluidTankComponent<BioReactorTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", BioReactorConfig.maxWaterTankStorage, 45, 20, 0).setColor(DyeColor.CYAN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().equals(Fluids.field_204546_a));
    @Save
    private LockableInventoryBundle<BioReactorTile> input;
    @Save
    private ProgressBarComponent<BioReactorTile> bar;

    public BioReactorTile() {
        super(ModuleGenerator.BIOREACTOR, BioReactorConfig.powerPerOperation);
        this.addTank(this.water);
        this.input = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("input", 69, 22, 9, 1).setColor(DyeColor.BLUE).setRange(3, 3).setInputFilter((stack, integer) -> this.canInsert(integer - 2, (ItemStack)stack)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this), 136, 84, false);
        this.addBundle((IComponentBundle)this.input);
        this.biofuel = (SidedFluidTankComponent)new SidedFluidTankComponent("biofuel", BioReactorConfig.maxBioFuelTankStorage, 128, 20, 2).setColor(DyeColor.PURPLE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.BIOFUEL.getSourceFluid()));
        this.addTank(this.biofuel);
        this.bar = new ProgressBarComponent<BioReactorTile>(150, 20, BioReactorConfig.maxProgress){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<BioReactorTile>(BioReactorTile.this.bar.getPosX(), BioReactorTile.this.bar.getPosY(), (ProgressBarComponent)this){

                    public List<ITextComponent> getTooltipLines() {
                        return Arrays.asList(new StringTextComponent(TextFormatting.GOLD + "Efficiency: " + TextFormatting.WHITE + (int)((double)BioReactorTile.this.getEfficiency() / 9.0 * 100.0) + TextFormatting.DARK_AQUA + "%"));
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(tileEntity -> true).setOnTickWork(() -> this.bar.setProgress((int)((double)this.getEfficiency() / 9.0 * 100.0))).setCanReset(tileEntity -> false).setComponentHarness((IComponentHarness)this);
        this.addProgressBar(this.bar);
        this.getMaxProgress = BioReactorConfig.maxProgress;
        this.getPowerPerOperation = BioReactorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            int efficiency = this.getEfficiency();
            if (efficiency <= 0) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            int fluidAmount = ((efficiency - 1) * 10 + 80) * efficiency;
            if (this.water.getFluidAmount() >= fluidAmount && this.biofuel.getCapacity() - this.biofuel.getFluidAmount() >= fluidAmount) {
                this.water.drainForced(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                this.biofuel.fillForced(new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid(), fluidAmount), IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                    this.input.getInventory().getStackInSlot(i).func_190918_g(1);
                }
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private boolean canInsert(int slot, ItemStack stack) {
        int foundSlot = -1;
        for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
            if (!this.input.getInventory().getStackInSlot(i).func_77969_a(stack)) continue;
            foundSlot = i;
        }
        for (ITag<Item> itemTag : VALID) {
            if (!itemTag.func_230235_a_((Object)stack.func_77973_b()) || foundSlot != -1 && (this.input.getInventory().getStackInSlot(foundSlot).func_190916_E() + stack.func_190916_E() > this.input.getInventory().getStackInSlot(foundSlot).func_77976_d() || slot != foundSlot)) continue;
            return true;
        }
        return false;
    }

    private int getEfficiency() {
        int slots = 0;
        for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
            if (this.input.getInventory().getStackInSlot(i).func_190926_b()) continue;
            ++slots;
        }
        return slots;
    }

    protected EnergyStorageComponent<BioReactorTile> createEnergyStorage() {
        return new EnergyStorageComponent(BioReactorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BioReactorTile getSelf() {
        return this;
    }
}

