/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentExtractorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnchantmentExtractorTile
extends IndustrialProcessingTile<EnchantmentExtractorTile> {
    @Save
    private boolean extractEnchants = true;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> inputEnchantedItem = (SidedInventoryComponent)new SidedInventoryComponent("inputEnchantedItem", 40, 22, 1, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> (stack.func_77948_v() || stack.func_77973_b() == Items.field_151134_bR) && !stack.func_77973_b().func_206844_a(IndustrialTags.Items.ENCHANTMENT_EXTRACTOR_BLACKLIST)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> inputBook;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> outputEnchantedBook;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> outputNoEnchantedItem;
    @Save
    private SidedFluidTankComponent<EnchantmentExtractorTile> tank;
    private ButtonComponent buttonComponent;

    public EnchantmentExtractorTile() {
        super(ModuleMisc.ENCHANTMENT_EXTRACTOR, 62, 40);
        this.addInventory((InventoryComponent)this.inputEnchantedItem);
        this.inputBook = (SidedInventoryComponent)new SidedInventoryComponent("inputBook", 40, 58, 1, 1).setColor(DyeColor.BROWN).setInputFilter((stack, integer) -> stack.func_77973_b().equals(Items.field_151122_aG)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Items.field_151122_aG)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputBook);
        this.outputNoEnchantedItem = (SidedInventoryComponent)new SidedInventoryComponent("outputNoEnchantedItem", 90, 22, 3, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.outputNoEnchantedItem);
        this.outputEnchantedBook = (SidedInventoryComponent)new SidedInventoryComponent("outputEnchantedBook", 90, 58, 3, 3).setColor(DyeColor.MAGENTA).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.outputEnchantedBook);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentExtractorConfig.tankSize, 150, 20, 4).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207185_a(IndustrialTags.Fluids.EXPERIENCE));
        this.addTank(this.tank);
        this.buttonComponent = new ButtonComponent(66, 58, 14, 14){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.enchantment_extractor.extract", (Object[])new Object[0]), "tooltip.industrialforegoing.enchantment_extractor.extract_extra"}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.enchantment_extractor.consume", (Object[])new Object[0]), "tooltip.industrialforegoing.enchantment_extractor.consume_extra"})}){

                    public int getState() {
                        return EnchantmentExtractorTile.this.extractEnchants ? 0 : 1;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.extractEnchants = !this.extractEnchants;
            this.markForUpdate();
        });
        this.addButton(this.buttonComponent);
    }

    @Override
    public boolean canIncrease() {
        return !this.inputEnchantedItem.getStackInSlot(0).func_190926_b() && !ItemStackUtils.isInventoryFull(this.outputNoEnchantedItem) && (this.extractEnchants ? !this.inputBook.getStackInSlot(0).func_190926_b() && !ItemStackUtils.isInventoryFull(this.outputEnchantedBook) : this.tank.getCapacity() >= this.tank.getFluidAmount() + this.getEnchantmentXp(this.inputEnchantedItem.getStackInSlot(0)) * 20);
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack input = this.inputEnchantedItem.getStackInSlot(0);
            if (this.extractEnchants) {
                Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)input).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (map.size() > 0) {
                    Enchantment selected = map.keySet().iterator().next();
                    ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
                    EnchantmentHelper.func_82782_a(Collections.singletonMap(selected, map.get(selected)), (ItemStack)book);
                    if (map.keySet().stream().allMatch(Enchantment::func_190936_d)) {
                        ItemStack output = input.func_77946_l();
                        input.func_190918_g(1);
                        ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                    } else if (map.size() == 1) {
                        ItemStack output = this.removeEnchantments(input, input.func_77952_i(), input.func_190916_E());
                        input.func_190918_g(1);
                        ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                        ItemHandlerHelper.insertItem(this.outputEnchantedBook, (ItemStack)book, (boolean)false);
                        this.inputBook.getStackInSlot(0).func_190918_g(1);
                    } else {
                        Map<Enchantment, Integer> cleanMap = EnchantmentHelper.func_82781_a((ItemStack)input).entrySet().stream().filter(enchantmentPair -> !((Enchantment)enchantmentPair.getKey()).equals(selected)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        if (input.func_77973_b() == Items.field_151134_bR) {
                            input.func_196083_e("Enchantments");
                            input.func_196083_e("StoredEnchantments");
                        }
                        EnchantmentHelper.func_82782_a(cleanMap, (ItemStack)input);
                        ItemHandlerHelper.insertItem(this.outputEnchantedBook, (ItemStack)book, (boolean)false);
                        this.inputBook.getStackInSlot(0).func_190918_g(1);
                    }
                }
            } else {
                int essence = this.getEnchantmentXp(input) * 20;
                ItemStack output = this.removeEnchantments(input, input.func_77952_i(), input.func_190916_E());
                input.func_190918_g(1);
                ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), essence), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentExtractorConfig.powerPerTick;
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentExtractorConfig.maxProgress;
    }

    public EnchantmentExtractorTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<EnchantmentExtractorTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentExtractorConfig.maxStoredPower, 10, 20);
    }

    private int getEnchantmentXp(ItemStack stack) {
        int xp = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.func_190936_d()) continue;
            xp += enchantment.func_77321_a(integer.intValue());
        }
        return xp;
    }

    private ItemStack removeEnchantments(ItemStack stack, int damage, int count) {
        ItemStack itemstack = stack.func_77946_l();
        itemstack.func_196083_e("Enchantments");
        itemstack.func_196083_e("StoredEnchantments");
        if (damage > 0) {
            itemstack.func_196085_b(damage);
        } else {
            itemstack.func_196083_e("Damage");
        }
        itemstack.func_190920_e(count);
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(enchantmentPair -> ((Enchantment)enchantmentPair.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.func_82782_a(map, (ItemStack)itemstack);
        itemstack.func_82841_c(0);
        if (itemstack.func_77973_b() == Items.field_151134_bR && map.size() == 0) {
            itemstack = new ItemStack((IItemProvider)Items.field_151122_aG);
            if (stack.func_82837_s()) {
                itemstack.func_200302_a(stack.func_200301_q());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.func_82841_c(RepairContainer.func_216977_d((int)itemstack.func_82838_A()));
        }
        return itemstack;
    }
}

