/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.FluidSievingMachineConfig;
import com.buuz135.industrial.fluid.OreTitaniumFluidAttributes;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.InventoryUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidSievingMachineTile
extends IndustrialProcessingTile<FluidSievingMachineTile> {
    @Save
    private SidedFluidTankComponent<FluidSievingMachineTile> input = (SidedFluidTankComponent)new SidedFluidTankComponent<FluidSievingMachineTile>("input", FluidSievingMachineConfig.maxTankSize, 35, 20, 0){

        protected void onContentsChanged() {
            FluidSievingMachineTile.this.syncObject(FluidSievingMachineTile.this.input);
        }

        public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
            return Collections.emptyList();
        }
    }.setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.FILL).setValidator(stack -> stack.getFluid().func_207187_a((Fluid)ModuleCore.FERMENTED_ORE_MEAT.getSourceFluid()));
    @Save
    private SidedInventoryComponent<FluidSievingMachineTile> sand;
    @Save
    private SidedInventoryComponent<FluidSievingMachineTile> output;

    public FluidSievingMachineTile() {
        super(ModuleResourceProduction.FLUID_SIEVING_MACHINE, 106, 40);
        this.addTank(this.input);
        this.sand = (SidedInventoryComponent)new SidedInventoryComponent("sand", 60, 31, 4, 1).setColor(DyeColor.YELLOW).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a((ITag)ItemTags.field_203440_u)).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Blocks.field_150354_m)).setSlotToItemStackRender(1, new ItemStack((IItemProvider)Blocks.field_150354_m)).setSlotToItemStackRender(2, new ItemStack((IItemProvider)Blocks.field_150354_m)).setSlotToItemStackRender(3, new ItemStack((IItemProvider)Blocks.field_150354_m)).setOutputFilter((stack, integer) -> false).setRange(2, 2);
        this.addInventory((InventoryComponent)this.sand);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 140, 40, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        return this.input.getFluidAmount() >= 100 && !InventoryUtil.getStacks(this.sand).isEmpty() && ItemHandlerHelper.insertItem(this.output, (ItemStack)OreTitaniumFluidAttributes.getOutputDust(this.input.getFluid()), (boolean)true).func_190926_b();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            for (int i = 0; i < this.sand.getSlots(); ++i) {
                if (this.sand.getStackInSlot(i).func_190926_b()) continue;
                this.sand.getStackInSlot(i).func_190918_g(1);
                break;
            }
            ItemStack output = OreTitaniumFluidAttributes.getOutputDust(this.input.getFluid());
            ItemHandlerHelper.insertItem(this.output, (ItemStack)output, (boolean)false);
            this.input.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
        };
    }

    @Override
    public int getMaxProgress() {
        return FluidSievingMachineConfig.maxProgress;
    }

    @Override
    protected int getTickPower() {
        return FluidSievingMachineConfig.powerPerTick;
    }

    @Nonnull
    public FluidSievingMachineTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<FluidSievingMachineTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidSievingMachineConfig.maxStoredPower, 10, 20);
    }
}

