/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonNestPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonSmallTunnelPiece;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SpiderDungeonBigTunnelPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private BlockPos endPos;
    private float pitch = 0.0f;
    private final float[] yaws = new float[30];
    private static final int LENGTH = 30;
    private static final float X_MINRADIUS = 2.0f;
    private static final float X_MAXRADIUS = 2.5f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 2.5f;
    private static final float Z_MINRADIUS = 2.0f;
    private static final float Z_MAXRADIUS = 2.5f;

    public SpiderDungeonBigTunnelPiece(int startX, int startZ, Random random) {
        this(new BlockPos(startX, random.nextInt((Integer)BDConfig.spiderDungeons.spiderDungeonStartMaxY.get() - (Integer)BDConfig.spiderDungeons.spiderDungeonStartMinY.get()) + (Integer)BDConfig.spiderDungeons.spiderDungeonStartMinY.get(), startZ), 0);
    }

    public SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength) {
        super(BDModStructurePieces.SPIDER_DUNGEON_BIG_TUNNEL_PIECE, pieceChainLength);
        this.field_74887_e = new MutableBoundingBox(startPos.func_177958_n() - 64, 1, startPos.func_177952_p() - 64, startPos.func_177958_n() + 64, 256, startPos.func_177952_p() + 64);
        this.startPos = new BlockPos((Vector3i)startPos);
        this.endPos = new BlockPos((Vector3i)startPos);
    }

    public SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength, float initialPitch, float initialYaw) {
        this(startPos, pieceChainLength);
        this.pitch = initialPitch;
        this.yaws[0] = initialYaw;
    }

    public SpiderDungeonBigTunnelPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(BDModStructurePieces.SPIDER_DUNGEON_BIG_TUNNEL_PIECE, compoundNBT);
        int[] start = compoundNBT.func_74759_k("startPos");
        int[] end = compoundNBT.func_74759_k("endPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.endPos = new BlockPos(end[0], end[1], end[2]);
        this.pitch = compoundNBT.func_74760_g("pitch");
        ListNBT yawListNBT = compoundNBT.func_150295_c("yawList", 5);
        for (int i = 0; i < 30; ++i) {
            this.yaws[i] = yawListNBT.func_150308_e(i);
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74783_a("startPos", new int[]{this.startPos.func_177958_n(), this.startPos.func_177956_o(), this.startPos.func_177952_p()});
        tagCompound.func_74783_a("endPos", new int[]{this.endPos.func_177958_n(), this.endPos.func_177956_o(), this.endPos.func_177952_p()});
        tagCompound.func_74776_a("pitch", this.pitch);
        ListNBT yawListNBT = new ListNBT();
        for (int i = 0; i < 30; ++i) {
            yawListNBT.add((Object)FloatNBT.func_229689_a_((float)this.yaws[i]));
        }
        tagCompound.func_218657_a("yawList", (INBT)yawListNBT);
    }

    @ParametersAreNonnullByDefault
    public void func_74861_a(StructurePiece piece, List<StructurePiece> pieceList, Random rand) {
        if (this.pitch == 0.0f) {
            this.pitch = MathHelper.func_76131_a((float)(rand.nextFloat() * (float)(-Math.PI)), (float)-2.6f, (float)-0.6f);
        }
        if (this.pitch > -2.2f && this.pitch < -1.0f) {
            this.pitch = -2.2f;
        }
        float pitchY = MathHelper.func_76126_a((float)this.pitch);
        float pitchXZ = MathHelper.func_76134_b((float)this.pitch);
        if (this.yaws[0] == 0.0f) {
            this.yaws[0] = rand.nextFloat() * ((float)Math.PI * 2);
        }
        float yawModifier = 0.0f;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        float caveStartX = this.startPos.func_177958_n();
        float caveStartY = this.startPos.func_177956_o();
        float caveStartZ = this.startPos.func_177952_p();
        caveStartX += MathHelper.func_76134_b((float)this.yaws[0]) * pitchXZ;
        caveStartY += MathHelper.func_76126_a((float)pitchY);
        caveStartZ += MathHelper.func_76126_a((float)this.yaws[0]) * pitchXZ;
        if (caveStartX - 2.5f - 4.0f < (float)minX) {
            minX = (int)caveStartX - 2 - 4;
        }
        if (caveStartX + 2.5f + 4.0f > (float)maxX) {
            maxX = (int)caveStartX + 2 + 4;
        }
        if (caveStartY - 2.5f - 4.0f < (float)minY) {
            minY = (int)caveStartY - 2 - 4;
        }
        if (caveStartY + 2.5f + 4.0f > (float)maxY) {
            maxY = (int)caveStartY + 2 + 4;
        }
        if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
            minZ = (int)caveStartZ - 2 - 4;
        }
        if (caveStartZ + 2.5f + 4.0f > (float)maxZ) {
            maxZ = (int)caveStartZ + 2 + 4;
        }
        for (int i = 1; i < 30; ++i) {
            yawModifier *= 0.75f;
            this.yaws[i] = this.yaws[i - 1] + (yawModifier += rand.nextFloat() * rand.nextFloat()) * 0.01f;
            caveStartX += MathHelper.func_76134_b((float)this.yaws[i]) * pitchXZ;
            caveStartY += MathHelper.func_76126_a((float)pitchY);
            caveStartZ += MathHelper.func_76126_a((float)this.yaws[i]) * pitchXZ;
            if (caveStartX - 2.5f - 4.0f < (float)minX) {
                minX = (int)caveStartX - 2 - 4;
            }
            if (caveStartX + 2.5f + 4.0f > (float)maxX) {
                maxX = (int)caveStartX + 2 + 4;
            }
            if (caveStartY - 2.5f - 4.0f < (float)minY) {
                minY = (int)caveStartY - 2 - 4;
            }
            if (caveStartY + 2.5f + 4.0f > (float)maxY) {
                maxY = (int)caveStartY + 2 + 4;
            }
            if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
                minZ = (int)caveStartZ - 2 - 4;
            }
            if (!(caveStartZ + 2.5f + 4.0f > (float)maxZ)) continue;
            maxZ = (int)caveStartZ + 2 + 4;
        }
        this.field_74887_e.field_78897_a = minX;
        this.field_74887_e.field_78893_d = maxX;
        this.field_74887_e.field_78895_b = minY;
        this.field_74887_e.field_78894_e = maxY;
        this.field_74887_e.field_78896_c = minZ;
        this.field_74887_e.field_78892_f = maxZ;
        this.endPos = new BlockPos((double)caveStartX, (double)caveStartY, (double)caveStartZ);
        if (this.field_74886_g == 0) {
            SpiderDungeonBigTunnelPiece nextBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.field_74886_g + 1, 0.0f, this.yaws[29]);
            pieceList.add(nextBigTunnelPiece);
            nextBigTunnelPiece.func_74861_a(nextBigTunnelPiece, pieceList, rand);
        }
        float smallTunnelAngle = this.yaws[29] + 0.3f;
        SpiderDungeonSmallTunnelPiece smallTunnelPiece1 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += rand.nextFloat() * 0.4f + 0.9f, this.field_74886_g + 1);
        pieceList.add(smallTunnelPiece1);
        smallTunnelPiece1.func_74861_a(smallTunnelPiece1, pieceList, rand);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece2 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += rand.nextFloat() * 0.4f + 0.9f, this.field_74886_g + 1);
        pieceList.add(smallTunnelPiece2);
        smallTunnelPiece2.func_74861_a(smallTunnelPiece2, pieceList, rand);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece3 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += rand.nextFloat() * 0.4f + 0.9f, this.field_74886_g + 1);
        pieceList.add(smallTunnelPiece3);
        smallTunnelPiece3.func_74861_a(smallTunnelPiece3, pieceList, rand);
        smallTunnelAngle += rand.nextFloat() * 0.4f + 0.9f;
        if (rand.nextFloat() < 0.5f) {
            SpiderDungeonSmallTunnelPiece smallTunnelPiece4 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle, this.field_74886_g + 1);
            pieceList.add(smallTunnelPiece4);
            smallTunnelPiece4.func_74861_a(smallTunnelPiece4, pieceList, rand);
        } else if (this.field_74886_g == 0) {
            SpiderDungeonBigTunnelPiece extraBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.field_74886_g + 1, rand.nextFloat() * (float)Math.PI / 6.0f - 0.5235988f, smallTunnelAngle);
            pieceList.add(extraBigTunnelPiece);
            extraBigTunnelPiece.func_74861_a(extraBigTunnelPiece, pieceList, rand);
        }
        SpiderDungeonNestPiece nestPiece = new SpiderDungeonNestPiece(this.endPos, this.field_74886_g + 1);
        pieceList.add(nestPiece);
        nestPiece.func_74861_a(nestPiece, pieceList, rand);
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        SharedSeedRandom decoRand = new SharedSeedRandom();
        decoRand.func_202424_a(world.func_72905_C(), this.startPos.func_177958_n(), this.startPos.func_177952_p());
        BitSet carvingMask = new BitSet(65536);
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(chunkPos.func_180334_c() + x, 1, chunkPos.func_180333_d() + z);
                surface[x * 16 + z] = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)mutable).func_177956_o();
            }
        }
        float caveStartX = this.startPos.func_177958_n();
        float caveStartY = this.startPos.func_177956_o();
        float caveStartZ = this.startPos.func_177952_p();
        for (int i = 0; i < 30; ++i) {
            float pitchY = MathHelper.func_76126_a((float)this.pitch);
            float pitchXZ = MathHelper.func_76134_b((float)this.pitch);
            float yaw = this.yaws[i];
            caveStartX += MathHelper.func_76134_b((float)yaw) * pitchXZ;
            caveStartY += MathHelper.func_76126_a((float)pitchY);
            caveStartZ += MathHelper.func_76126_a((float)yaw) * pitchXZ;
            float xRadius = MathHelper.func_219799_g((float)MathHelper.func_76126_a((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float yRadius = MathHelper.func_219799_g((float)MathHelper.func_76126_a((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float zRadius = MathHelper.func_219799_g((float)MathHelper.func_76126_a((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            int minX = MathHelper.func_76141_d((float)(caveStartX - xRadius)) - chunkPos.field_77276_a * 16 - 1;
            int maxX = MathHelper.func_76141_d((float)(caveStartX + xRadius)) - chunkPos.field_77276_a * 16 + 1;
            int minY = MathHelper.func_76125_a((int)(MathHelper.func_76141_d((float)(caveStartY - yRadius)) - 1), (int)0, (int)255);
            int maxY = MathHelper.func_76125_a((int)(MathHelper.func_76141_d((float)(caveStartY + yRadius)) + 1), (int)0, (int)255);
            int minZ = MathHelper.func_76141_d((float)(caveStartZ - zRadius)) - chunkPos.field_77275_b * 16 - 1;
            int maxZ = MathHelper.func_76141_d((float)(caveStartZ + zRadius)) - chunkPos.field_77275_b * 16 + 1;
            minX = MathHelper.func_76125_a((int)minX, (int)0, (int)15);
            maxX = MathHelper.func_76125_a((int)maxX, (int)0, (int)15);
            minZ = MathHelper.func_76125_a((int)minZ, (int)0, (int)15);
            maxZ = MathHelper.func_76125_a((int)maxZ, (int)0, (int)15);
            for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
                int globalX = (int)x + chunkPos.field_77276_a * 16;
                if (globalX < chunkPos.func_180334_c() || globalX > chunkPos.func_180332_e()) continue;
                float radialXDist = ((float)globalX - caveStartX + 0.5f) / xRadius;
                for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                    int globalY;
                    int globalZ = (int)z + chunkPos.field_77275_b * 16;
                    if (globalZ < chunkPos.func_180333_d() || globalZ > chunkPos.func_180330_f()) continue;
                    float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / zRadius;
                    for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                        BlockState state;
                        float radialYDist = (y - caveStartY - 0.5f) / yRadius;
                        int mask = (int)x | (int)z << 4 | (int)y << 8;
                        float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                        if (!carvingMask.get(mask) && (double)radialDist < 1.0) {
                            if (BLOCK_BLACKLIST.contains(this.func_175807_a((IBlockReader)world, globalX, globalY, globalZ, box).func_177230_c())) continue;
                            this.func_175811_a(world, Blocks.field_201941_jj.func_176223_P(), globalX, globalY, globalZ, box);
                            carvingMask.set(mask);
                            continue;
                        }
                        float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (xRadius + 1.2f);
                        float radialYDistShell = (y - caveStartY - 0.5f) / (yRadius + 1.2f);
                        float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (zRadius + 1.2f);
                        float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                        if (carvingMask.get(mask) || !((double)radialDistShell < 1.0) || BLOCK_BLACKLIST.contains((state = this.func_175807_a((IBlockReader)world, globalX, globalY, globalZ, box)).func_177230_c()) || !state.func_196958_f() && state.func_204520_s().func_206886_c() == Fluids.field_204541_a && !(decoRand.nextFloat() < 0.2f)) continue;
                        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), globalX, globalY, globalZ, box);
                    }
                }
            }
        }
        this.decorateCave(world, (Random)decoRand, chunkPos, box, carvingMask);
        return true;
    }
}

