/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.lodBuilding;

import com.seibel.lod.core.builders.lodBuilding.LodBuilderConfig;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.enums.config.BlocksToAvoid;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.LodRegion;
import com.seibel.lod.core.objects.lod.LodWorld;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodThreadFactory;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;

public class LodBuilder {
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    private static final ILodConfigWrapperSingleton config = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodBuilder.class), () -> config.client().advanced().debugging().debugSwitch().getLogLodBuilderEvent());
    public static short MIN_WORLD_HEIGHT = 0;
    public static final short DEFAULT_MAX_LIGHT = 15;
    private final ExecutorService lodGenThreadPool = Executors.newSingleThreadExecutor(new LodThreadFactory(this.getClass().getSimpleName(), 4));
    public int defaultDimensionWidthInRegions = 1;
    public static final LodDirection[] DIRECTIONS = new LodDirection[]{LodDirection.UP, LodDirection.DOWN, LodDirection.WEST, LodDirection.EAST, LodDirection.NORTH, LodDirection.SOUTH};

    public void generateLodNodeAsync(IChunkWrapper chunk, LodWorld lodWorld, IDimensionTypeWrapper dim, boolean genAll) {
        this.generateLodNodeAsync(chunk, lodWorld, dim, DistanceGenerationMode.FULL, true, genAll, () -> {}, () -> this.generateLodNodeAsync(chunk, lodWorld, dim, genAll));
    }

    public void generateLodNodeAsync(IChunkWrapper chunk, LodWorld lodWorld, IDimensionTypeWrapper dim, DistanceGenerationMode generationMode, boolean override, boolean genAll, Runnable endCallback, Runnable retryCallback) {
        if (lodWorld == null || lodWorld.getIsWorldNotLoaded()) {
            endCallback.run();
            return;
        }
        if (chunk == null) {
            endCallback.run();
            return;
        }
        Runnable thread = () -> {
            boolean retryNeeded = false;
            try {
                if (MC.getWrappedClientWorld() == null) {
                    return;
                }
                if (!MC.hasSinglePlayerServer() && !MC.connectedToServer()) {
                    return;
                }
                LodDimension lodDim = lodWorld.getLodDimension(dim);
                if (lodDim == null) {
                    return;
                }
                retryNeeded = !this.generateLodNodeFromChunk(lodDim, chunk, new LodBuilderConfig(generationMode), override, genAll);
            }
            catch (RuntimeException e) {
                EVENT_LOGGER.error("LodBuilder Thread Uncaught Exception: ", e);
            }
            finally {
                if (!retryNeeded) {
                    endCallback.run();
                } else {
                    retryCallback.run();
                }
            }
        };
        this.lodGenThreadPool.execute(thread);
    }

    public boolean generateLodNodeFromChunk(LodDimension lodDim, IChunkWrapper chunk, LodBuilderConfig config, boolean override, boolean genAll) {
        try {
            if (chunk == null) {
                throw new IllegalArgumentException("generateLodFromChunk given a null chunk");
            }
            LodRegion region = lodDim.getRegion(chunk.getRegionPosX(), chunk.getRegionPosZ());
            if (region == null) {
                return false;
            }
            if (MC.getWrappedClientWorld() == null) {
                return false;
            }
            if (!LodBuilder.canGenerateLodFromChunk(chunk)) {
                return false;
            }
            int maxVerticalData = DetailDistanceUtil.getMaxVerticalData(0);
            long[] data = new long[maxVerticalData * 16 * 16];
            boolean isAllVoid = true;
            if (!config.quickFillWithVoid) {
                for (int i = 0; i < 256; ++i) {
                    int subX = i / 16;
                    int subZ = i % 16;
                    this.writeVerticalData(data, i * maxVerticalData, maxVerticalData, chunk, config, subX, subZ);
                    isAllVoid &= DataPointUtil.isVoid(data[i * maxVerticalData]);
                    if (!DataPointUtil.doesItExist(data[i * maxVerticalData])) {
                        throw new RuntimeException("writeVerticalData result: Datapoint does not exist at " + chunk.getMinX() + subX + ", " + chunk.getMinZ() + subZ);
                    }
                    if (DataPointUtil.getGenerationMode(data[i * maxVerticalData]) == config.distanceGenerationMode.complexity) continue;
                    throw new RuntimeException("writeVerticalData result: Datapoint invalid at " + chunk.getMinX() + subX + ", " + chunk.getMinZ() + subZ);
                }
            } else {
                for (int i = 0; i < 256; ++i) {
                    data[i * maxVerticalData] = DataPointUtil.createVoidDataPoint(config.distanceGenerationMode.complexity);
                }
            }
            if (isAllVoid) {
                EVENT_LOGGER.debug("The chunk {} is completely void.", chunk);
            }
            if (!LodBuilder.canGenerateLodFromChunk(chunk)) {
                return false;
            }
            if (genAll) {
                return this.writeAllLodNodeData(lodDim, region, chunk.getChunkPosX(), chunk.getChunkPosZ(), data, config, override);
            }
            return this.writePartialLodNodeData(lodDim, region, chunk.getChunkPosX(), chunk.getChunkPosZ(), data, config, override);
        }
        catch (RuntimeException e) {
            EVENT_LOGGER.error("LodBuilder encountered an error on building lod: ", e);
            return false;
        }
    }

    public static boolean canGenerateLodFromChunk(IChunkWrapper chunk) {
        return chunk != null && chunk.isLightCorrect() && chunk.doesNearbyChunksExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeAllLodNodeData(LodDimension lodDim, LodRegion region, int chunkX, int chunkZ, long[] data, LodBuilderConfig config, boolean override) {
        region.isWriting.incrementAndGet();
        try {
            if (region.getMinDetailLevel() != 0) {
                if (!LodUtil.checkRamUsage(0.05, 16)) {
                    EVENT_LOGGER.debug("LodBuilder: Not enough RAM avalible for loading files to build lods! Returning...", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                LodRegion newRegion = lodDim.getRegionFromFile(region, (byte)0, region.getVerticalQuality());
                if (region != newRegion) {
                    throw new RuntimeException();
                }
            }
            region.addChunkOfData((byte)0, chunkX * 16, chunkZ * 16, 16, 16, data, data.length / 16 / 16, override);
            region.regenerateLodFromArea((byte)0, chunkX * 16, chunkZ * 16, 16, 16);
            if (!region.doesDataExist((byte)0, chunkX * 16, chunkZ * 16, config.distanceGenerationMode)) {
                throw new RuntimeException("data at detail 0 is still null after writes to it!");
            }
            if (!region.doesDataExist((byte)4, chunkX, chunkZ, config.distanceGenerationMode)) {
                throw new RuntimeException("data at chunk detail level is still null after writes to it!");
            }
        }
        finally {
            region.isWriting.decrementAndGet();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePartialLodNodeData(LodDimension lodDim, LodRegion region, int chunkX, int chunkZ, long[] data, LodBuilderConfig config, boolean override) {
        region.isWriting.incrementAndGet();
        try {
            int lodCount;
            byte targetLevel = region.getMinDetailLevel();
            int vertQual = DetailDistanceUtil.getMaxVerticalData(targetLevel);
            int n = lodCount = targetLevel >= 4 ? 1 : 1 << 4 - targetLevel;
            if (targetLevel != 0) {
                int lodWidth = 16 / lodCount;
                int inputVertQual = data.length / 16 / 16;
                long[] mergedData = new long[vertQual * lodCount * lodCount];
                for (int subX = 0; subX < lodCount; ++subX) {
                    for (int subZ = 0; subZ < lodCount; ++subZ) {
                        long[] toBeMerged = DataPointUtil.extractDataArray(data, 16, 16, subX * lodWidth, subZ * lodWidth, lodWidth, lodWidth);
                        if (toBeMerged.length != lodWidth * lodWidth * inputVertQual) {
                            throw new RuntimeException();
                        }
                        long[] merged = DataPointUtil.mergeMultiData(toBeMerged, inputVertQual, vertQual);
                        if (merged.length != vertQual) {
                            throw new RuntimeException();
                        }
                        if (!DataPointUtil.doesItExist(merged[0]) || DataPointUtil.getGenerationMode(merged[0]) != config.distanceGenerationMode.complexity) {
                            throw new RuntimeException();
                        }
                        System.arraycopy(merged, 0, mergedData, (subZ + subX * lodCount) * vertQual, vertQual);
                    }
                }
                data = mergedData;
            }
            if (lodCount * lodCount * vertQual != data.length) {
                throw new RuntimeException();
            }
            for (int i = 0; i < data.length; i += vertQual) {
                if (DataPointUtil.doesItExist(data[i]) && DataPointUtil.getGenerationMode(data[i]) == config.distanceGenerationMode.complexity) continue;
                EVENT_LOGGER.error("NULL data at {}, detail {}, vertQual {}, lodCount {}, chunkPos [{},{}]\nData: {}", i, targetLevel, vertQual, lodCount, chunkX, chunkZ, DataPointUtil.toString(data[i]));
                throw new RuntimeException("Null data!");
            }
            if (targetLevel != region.getMinDetailLevel()) {
                throw new ConcurrentModificationException("Min detail level changed while writing data");
            }
            region.addChunkOfData(targetLevel, LevelPosUtil.convert((byte)4, chunkX, targetLevel), LevelPosUtil.convert((byte)4, chunkZ, targetLevel), lodCount, lodCount, data, vertQual, override);
            region.regenerateLodFromArea(targetLevel, LevelPosUtil.convert((byte)4, chunkX, targetLevel), LevelPosUtil.convert((byte)4, chunkZ, targetLevel), lodCount, lodCount);
            if (!region.doesDataExist(targetLevel, LevelPosUtil.convert((byte)4, chunkX, targetLevel), LevelPosUtil.convert((byte)4, chunkZ, targetLevel), config.distanceGenerationMode)) {
                throw new RuntimeException("data at detail " + targetLevel + " is still null after writes to it!");
            }
        }
        catch (Exception e) {
            EVENT_LOGGER.error("LodBuilder encountered an error on writePartialLodNodeData: ", e);
        }
        finally {
            region.isWriting.decrementAndGet();
        }
        return true;
    }

    private void writeVerticalData(long[] data, int dataOffset, int maxVerticalData, IChunkWrapper chunk, LodBuilderConfig config, int chunkSubPosX, int chunkSubPosZ) {
        long[] result;
        int totalVerticalData = chunk.getHeight();
        long[] dataToMerge = new long[totalVerticalData];
        boolean hasCeiling = MC.getWrappedClientWorld().getDimensionType().hasCeiling();
        boolean hasSkyLight = MC.getWrappedClientWorld().getDimensionType().hasSkyLight();
        byte generation = config.distanceGenerationMode.complexity;
        int count = 0;
        int x = chunk.getMinX() + chunkSubPosX;
        int z = chunk.getMinZ() + chunkSubPosZ;
        int y = chunk.getMaxY(x, z);
        boolean topBlock = true;
        if (y < chunk.getMinBuildHeight()) {
            dataToMerge[0] = DataPointUtil.createVoidDataPoint(generation);
        }
        int maxConnectedLods = LodBuilder.config.client().graphics().quality().getVerticalQuality().maxVerticalData[0];
        while (y >= chunk.getMinBuildHeight()) {
            int height = this.determineHeightPointFrom(chunk, config, x, y, z);
            if (height < chunk.getMinBuildHeight()) {
                if (!topBlock) break;
                dataToMerge[0] = DataPointUtil.createVoidDataPoint(generation);
                break;
            }
            y = height - 1;
            int depth = this.determineBottomPointFrom(chunk, config, x, y, z, count < maxConnectedLods && (!hasCeiling || !topBlock));
            if (hasCeiling && topBlock) {
                y = depth;
            }
            int light = this.getLightValue(chunk, x, y, z, hasCeiling, hasSkyLight, topBlock);
            int color = this.generateLodColor(chunk, config, x, y, z);
            int lightBlock = light & 0xF;
            int lightSky = light >> 4 & 0xF;
            dataToMerge[count] = DataPointUtil.createDataPoint(height - chunk.getMinBuildHeight(), depth - chunk.getMinBuildHeight(), color, lightSky, lightBlock, generation);
            topBlock = false;
            y = depth - 1;
            ++count;
        }
        if ((result = DataPointUtil.mergeMultiData(dataToMerge, totalVerticalData, maxVerticalData)).length != maxVerticalData) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(result, 0, data, dataOffset, maxVerticalData);
    }

    private boolean hasCliffFace(IChunkWrapper chunk, int x, int y, int z) {
        for (LodDirection dir : DIRECTIONS) {
            IBlockDetailWrapper block = chunk.getBlockDetailAtFace(x, y, z, dir);
            if (block != null && block.hasFaceCullingFor(LodDirection.OPPOSITE_DIRECTIONS[dir.ordinal()])) continue;
            return true;
        }
        return false;
    }

    private int determineBottomPointFrom(IChunkWrapper chunk, LodBuilderConfig builderConfig, int xAbs, int yAbs, int zAbs, boolean strictEdge) {
        int depth = chunk.getMinBuildHeight();
        IBlockDetailWrapper currentBlockDetail = null;
        if (strictEdge) {
            IBlockDetailWrapper blockAbove = chunk.getBlockDetail(xAbs, yAbs + 1, zAbs);
            if (blockAbove != null && !blockAbove.shouldRender(config.client().worldGenerator().getBlocksToAvoid())) {
                currentBlockDetail = blockAbove;
            }
            if (currentBlockDetail == null) {
                currentBlockDetail = chunk.getBlockDetail(xAbs, yAbs, zAbs);
            }
        }
        for (int y = yAbs - 1; y >= chunk.getMinBuildHeight(); --y) {
            IBlockDetailWrapper nextBlock = chunk.getBlockDetail(xAbs, y, zAbs);
            if (this.isLayerValidLodPoint(nextBlock) && (!strictEdge || currentBlockDetail.equals(nextBlock) || !this.hasCliffFace(chunk, xAbs, y, zAbs))) continue;
            depth = y + 1;
            break;
        }
        return depth;
    }

    private int determineHeightPointFrom(IChunkWrapper chunk, LodBuilderConfig config, int xAbs, int yAbs, int zAbs) {
        int height = chunk.getMinBuildHeight() - 1;
        for (int y = yAbs; y >= chunk.getMinBuildHeight(); --y) {
            if (!this.isLayerValidLodPoint(chunk, xAbs, y, zAbs)) continue;
            height = y + 1;
            break;
        }
        return height;
    }

    private int generateLodColor(IChunkWrapper chunk, LodBuilderConfig builderConfig, int x, int y, int z) {
        int colorInt;
        if (builderConfig.useBiomeColors) {
            colorInt = chunk.getBiome(x, y, z).getColorForBiome(x, z);
        } else {
            IBlockDetailWrapper blockAbove;
            colorInt = 0;
            if (chunk.blockPosInsideChunk(x, y + 1, z) && (blockAbove = chunk.getBlockDetail(x, y + 1, z)) != null && !blockAbove.shouldRender(config.client().worldGenerator().getBlocksToAvoid())) {
                colorInt = blockAbove.getAndResolveFaceColor(null, chunk, FACTORY.createBlockPos(x, y + 1, z));
            }
            if (colorInt == 0) {
                IBlockDetailWrapper detail = chunk.getBlockDetail(x, y, z);
                colorInt = detail.getAndResolveFaceColor(null, chunk, FACTORY.createBlockPos(x, y, z));
            }
        }
        return colorInt;
    }

    private int getLightValue(IChunkWrapper chunk, int x, int y, int z, boolean hasCeiling, boolean hasSkyLight, boolean topBlock) {
        int skyLight;
        int blockBrightness = chunk.getEmittedBrightness(x, y, z);
        y = hasCeiling && topBlock ? --y : ++y;
        int blockLight = chunk.getBlockLight(x, y, z);
        int n = skyLight = hasSkyLight ? chunk.getSkyLight(x, y, z) : 0;
        if (blockLight == -1 || skyLight == -1) {
            IWorldWrapper world = MC.getWrappedServerWorld();
            if (world != null) {
                blockLight = world.getBlockLight(x, y, z);
                if (topBlock && !hasCeiling && hasSkyLight) {
                    skyLight = 15;
                } else {
                    int n2 = skyLight = hasSkyLight ? world.getSkyLight(x, y, z) : 0;
                }
                if (!topBlock && skyLight == 15) {
                    skyLight = 12;
                }
            } else {
                world = MC.getWrappedClientWorld();
                if (world == null) {
                    blockLight = 0;
                    skyLight = 12;
                } else {
                    blockLight = world.getBlockLight(x, y, z);
                    if (hasSkyLight || !hasCeiling) {
                        if (topBlock) {
                            skyLight = 15;
                        } else {
                            if (hasSkyLight) {
                                skyLight = world.getSkyLight(x, y, z);
                            }
                            if (!(chunk.isLightCorrect() || skyLight != 0 && skyLight != 15)) {
                                skyLight = 12;
                            }
                        }
                    }
                }
            }
        }
        blockLight = LodUtil.clamp(0, Math.max(blockLight, blockBrightness), 15);
        return blockLight + (skyLight << 4);
    }

    private boolean isLayerValidLodPoint(IBlockDetailWrapper blockDetail) {
        BlocksToAvoid avoid = config.client().worldGenerator().getBlocksToAvoid();
        return blockDetail != null && blockDetail.shouldRender(avoid);
    }

    private boolean isLayerValidLodPoint(IChunkWrapper chunk, int x, int y, int z) {
        BlocksToAvoid avoid = config.client().worldGenerator().getBlocksToAvoid();
        IBlockDetailWrapper block = chunk.getBlockDetail(x, y, z);
        return block != null && block.shouldRender(avoid);
    }
}

