/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects;

import com.seibel.lod.core.util.LevelPosUtil;

public class PosToGenerateContainer {
    private final int playerPosX;
    private final int playerPosZ;
    private int nearSize;
    private int farSize;
    private final int[][] nearPosToGenerate;
    private final int[][] farPosToGenerate;

    public PosToGenerateContainer(int maxDataToGenerate, int playerPosX, int playerPosZ) {
        this.playerPosX = playerPosX;
        this.playerPosZ = playerPosZ;
        this.nearSize = 0;
        this.farSize = 0;
        this.nearPosToGenerate = new int[maxDataToGenerate][4];
        this.farPosToGenerate = new int[maxDataToGenerate][4];
    }

    public void addNearPosToGenerate(byte detailLevel, int posX, int posZ, boolean sort) {
        int index;
        int distance = (int)LevelPosUtil.minDistance(detailLevel, posX, posZ, this.playerPosX, this.playerPosZ);
        if ((index = this.nearSize++) == this.nearPosToGenerate.length) {
            if (Integer.compare(distance, this.nearPosToGenerate[index - 1][3]) > 0) {
                return;
            }
            --index;
        }
        if (sort) {
            while (index > 0 && Integer.compare(distance, this.nearPosToGenerate[index - 1][3]) <= 0) {
                this.nearPosToGenerate[index][0] = this.nearPosToGenerate[index - 1][0];
                this.nearPosToGenerate[index][1] = this.nearPosToGenerate[index - 1][1];
                this.nearPosToGenerate[index][2] = this.nearPosToGenerate[index - 1][2];
                this.nearPosToGenerate[index][3] = this.nearPosToGenerate[index - 1][3];
                --index;
            }
        }
        this.nearPosToGenerate[index][0] = detailLevel + 1;
        this.nearPosToGenerate[index][1] = posX;
        this.nearPosToGenerate[index][2] = posZ;
        this.nearPosToGenerate[index][3] = distance;
    }

    public void addFarPosToGenerate(byte detailLevel, int posX, int posZ, boolean sort) {
        int index;
        int distance = (int)LevelPosUtil.minDistance(detailLevel, posX, posZ, this.playerPosX, this.playerPosZ);
        if ((index = this.farSize++) == this.farPosToGenerate.length) {
            if (Integer.compare(distance, this.farPosToGenerate[index - 1][3]) > 0) {
                return;
            }
            --index;
        }
        if (sort) {
            while (index > 0 && Integer.compare(distance, this.farPosToGenerate[index - 1][3]) <= 0) {
                this.farPosToGenerate[index][0] = this.farPosToGenerate[index - 1][0];
                this.farPosToGenerate[index][1] = this.farPosToGenerate[index - 1][1];
                this.farPosToGenerate[index][2] = this.farPosToGenerate[index - 1][2];
                this.farPosToGenerate[index][3] = this.farPosToGenerate[index - 1][3];
                --index;
            }
        }
        this.farPosToGenerate[index][0] = detailLevel + 1;
        this.farPosToGenerate[index][1] = posX;
        this.farPosToGenerate[index][2] = posZ;
        this.farPosToGenerate[index][3] = distance;
    }

    public boolean isFull() {
        return this.nearSize == this.nearPosToGenerate.length && this.farSize == this.farPosToGenerate.length;
    }

    public int getNumberOfPos() {
        return this.nearSize + this.farSize;
    }

    public int getNumberOfNearPos() {
        return this.nearSize;
    }

    public int getNumberOfFarPos() {
        return this.farSize;
    }

    public int getMaxNumberOfNearPos() {
        return this.nearPosToGenerate.length;
    }

    public int getMaxNumberOfFarPos() {
        return this.farPosToGenerate.length;
    }

    public int getNthDetail(int n, boolean near) {
        if (near) {
            return this.nearPosToGenerate[n][0];
        }
        return this.farPosToGenerate[n][0];
    }

    public int getNthPosX(int n, boolean near) {
        if (near) {
            return this.nearPosToGenerate[n][1];
        }
        return this.farPosToGenerate[n][1];
    }

    public int getNthPosZ(int n, boolean near) {
        if (near) {
            return this.nearPosToGenerate[n][2];
        }
        return this.farPosToGenerate[n][2];
    }

    public int getNthGeneration(int n, boolean near) {
        if (near) {
            return this.nearPosToGenerate[n][3];
        }
        return this.farPosToGenerate[n][3];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append('\n');
        builder.append('\n');
        builder.append("near pos to generate");
        builder.append('\n');
        for (int[] ints : this.nearPosToGenerate) {
            if (ints[0] == 0) break;
            builder.append(ints[0] - 1);
            builder.append(" ");
            builder.append(ints[1]);
            builder.append(" ");
            builder.append(ints[2]);
            builder.append(" ");
            builder.append(ints[3]);
            builder.append('\n');
        }
        builder.append('\n');
        builder.append("far pos to generate");
        builder.append('\n');
        for (int[] ints : this.farPosToGenerate) {
            if (ints[0] == 0) break;
            builder.append(ints[0] - 1);
            builder.append(" ");
            builder.append(ints[1]);
            builder.append(" ");
            builder.append(ints[2]);
            builder.append(" ");
            builder.append(ints[3]);
            builder.append('\n');
        }
        return builder.toString();
    }
}

