/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.opengl;

public class LodVertexFormatElement {
    private final DataType dataType;
    private final int index;
    private final int count;
    private final int byteSize;
    private final boolean isPadding;

    public LodVertexFormatElement(int newIndex, DataType newType, int newCount, boolean isPadding) {
        this.dataType = newType;
        this.index = newIndex;
        this.count = newCount;
        this.byteSize = newType.getSize() * this.count;
        this.isPadding = isPadding;
    }

    public final boolean getIsPadding() {
        return this.isPadding;
    }

    public final DataType getType() {
        return this.dataType;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getByteSize() {
        return this.byteSize;
    }

    public int getElementCount() {
        return this.count;
    }

    public int hashCode() {
        int i = this.dataType.hashCode();
        i = 31 * i + this.index;
        return 31 * i + this.count;
    }

    public String toString() {
        return this.count + "," + this.dataType.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            LodVertexFormatElement LodVertexFormatElement2 = (LodVertexFormatElement)obj;
            if (this.count != LodVertexFormatElement2.count) {
                return false;
            }
            if (this.index != LodVertexFormatElement2.index) {
                return false;
            }
            if (this.dataType != LodVertexFormatElement2.dataType) {
                return false;
            }
            return false;
        }
        return false;
    }

    public static enum DataType {
        FLOAT(4, "Float", 5126),
        UBYTE(1, "Unsigned Byte", 5121),
        BYTE(1, "Byte", 5120),
        USHORT(2, "Unsigned Short", 5123),
        SHORT(2, "Short", 5122),
        UINT(4, "Unsigned Int", 5125),
        INT(4, "Int", 5124);

        private final int size;
        private final String name;
        private final int glType;

        private DataType(int sizeInBytes, String newName, int openGlDataType) {
            this.size = sizeInBytes;
            this.name = newName;
            this.glType = openGlDataType;
        }

        public int getSize() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        public int getGlType() {
            return this.glType;
        }
    }
}

