/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.enums.rendering.GLProxyContext;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.util.GLMessage;
import com.seibel.lod.core.util.GLMessageOutputStream;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;

public class GLProxy {
    public static final boolean OVERWIDE_VANILLA_GL_LOGGER = false;
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private ExecutorService workerThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(GLProxy.class.getSimpleName() + "-Worker-Thread").build());
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final ConfigBasedLogger GL_LOGGER = new ConfigBasedLogger(LogManager.getLogger(GLProxy.class), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogRendererGLEvent());
    private static GLProxy instance = null;
    public final long minecraftGlContext;
    public final GLCapabilities minecraftGlCapabilities;
    public final long lodBuilderGlContext;
    public final GLCapabilities lodBuilderGlCapabilities;
    public final long proxyWorkerGlContext;
    public final GLCapabilities proxyWorkerGlCapabilities;
    public boolean namedObjectSupported = false;
    public boolean bufferStorageSupported = false;
    public boolean VertexAttributeBufferBindingSupported = false;
    private final GpuUploadMethod preferredUploadMethod;
    public final GLMessage.Builder vanillaDebugMessageBuilder;
    public final GLMessage.Builder lodBuilderDebugMessageBuilder = new GLMessage.Builder(type -> {
        if (type == GLMessage.Type.POP_GROUP) {
            return false;
        }
        if (type == GLMessage.Type.PUSH_GROUP) {
            return false;
        }
        if (type == GLMessage.Type.MARKER) {
            return false;
        }
        return true;
    }, severity -> {
        if (severity == GLMessage.Severity.NOTIFICATION) {
            return false;
        }
        return true;
    }, null);
    public final GLMessage.Builder proxyWorkerDebugMessageBuilder = new GLMessage.Builder(type -> {
        if (type == GLMessage.Type.POP_GROUP) {
            return false;
        }
        if (type == GLMessage.Type.PUSH_GROUP) {
            return false;
        }
        if (type == GLMessage.Type.MARKER) {
            return false;
        }
        return true;
    }, severity -> {
        if (severity == GLMessage.Severity.NOTIFICATION) {
            return false;
        }
        return true;
    }, null);

    private String getFailedVersionInfo(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: " + c.OpenGL32 + " <- REQUIRED\nVertex Attribute Buffer Binding: " + (c.glVertexAttribBinding != 0L) + " <- optional improvement\nBuffer Storage: " + (c.glBufferStorage != 0L) + " <- optional improvement\nIf you noticed that your computer supports higher OpenGL versions but not the required version, try running the game in compatibility mode. (How you turn that on, I have no clue~)";
    }

    private boolean checkCapabilities(GLCapabilities c) {
        if (!c.OpenGL32) {
            return false;
        }
        this.namedObjectSupported = c.glNamedBufferStorage != 0L;
        this.bufferStorageSupported = c.glBufferStorage != 0L;
        this.VertexAttributeBufferBindingSupported = c.glVertexAttribBinding != 0L;
        return true;
    }

    private String getVersionInfo(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: " + c.OpenGL32 + " <- REQUIRED\nVertex Attribute Buffer Binding: " + (c.glVertexAttribBinding != 0L) + " <- optional improvement\nBuffer Storage: " + (c.glBufferStorage != 0L) + " <- optional improvement\n";
    }

    private static void logMessage(GLMessage msg) {
        GLMessage.Severity s = msg.severity;
        if (msg.type == GLMessage.Type.ERROR || msg.type == GLMessage.Type.UNDEFINED_BEHAVIOR) {
            GL_LOGGER.error("GL ERROR {} from {}: {}", new Object[]{msg.id, msg.source, msg.message});
            throw new RuntimeException("GL ERROR: " + msg.toString());
        }
        RuntimeException e = new RuntimeException("GL MESSAGE: " + msg.toString());
        switch (s) {
            case HIGH: {
                GL_LOGGER.error("{}", e);
                break;
            }
            case MEDIUM: {
                GL_LOGGER.warn("{}", e);
                break;
            }
            case LOW: {
                GL_LOGGER.info("{}", e);
                break;
            }
            case NOTIFICATION: {
                GL_LOGGER.debug("{}", e);
            }
        }
    }

    private GLProxy() {
        String vendor;
        this.vanillaDebugMessageBuilder = new GLMessage.Builder(type -> {
            if (type == GLMessage.Type.POP_GROUP) {
                return false;
            }
            if (type == GLMessage.Type.PUSH_GROUP) {
                return false;
            }
            if (type == GLMessage.Type.MARKER) {
                return false;
            }
            return true;
        }, severity -> {
            if (severity == GLMessage.Severity.NOTIFICATION) {
                return false;
            }
            return true;
        }, null);
        GL_LOGGER.info("Creating " + GLProxy.class.getSimpleName() + "... If this is the last message you see in the log there must have been a OpenGL error.", new Object[0]);
        GL_LOGGER.info("Lod Render OpenGL version [" + GL11.glGetString((int)7938) + "].", new Object[0]);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            throw new IllegalStateException(GLProxy.class.getSimpleName() + " was created outside the render thread!");
        }
        this.minecraftGlContext = GLFW.glfwGetCurrentContext();
        this.minecraftGlCapabilities = GL.getCapabilities();
        if (!this.minecraftGlCapabilities.OpenGL32) {
            String supportedVersionInfo = this.getFailedVersionInfo(this.minecraftGlCapabilities);
            String errorMessage = "Distant Horizons was initializing " + GLProxy.class.getSimpleName() + " and discovered this GPU doesn't meet the OpenGL requirement. Sorry I couldn't tell you sooner :(\nAdditional info:\n" + supportedVersionInfo;
            MC.crashMinecraft(errorMessage, new UnsupportedOperationException("Distant Horizon OpenGL requirements not met"));
        }
        GL_LOGGER.info("minecraftGlCapabilities:\n" + this.getVersionInfo(this.minecraftGlCapabilities), new Object[0]);
        GLFW.glfwMakeContextCurrent((long)0L);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139270, (int)1);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139271, (int)1);
        this.lodBuilderGlContext = GLFW.glfwCreateWindow((int)64, (int)48, (CharSequence)"LOD Builder Window", (long)0L, (long)this.minecraftGlContext);
        if (this.lodBuilderGlContext == 0L) {
            GL_LOGGER.error("ERROR: Failed to create GLFW context for OpenGL 3.2 with Forward Compat Core Profile! Your OS may have not been able to support it!", new Object[0]);
            throw new UnsupportedOperationException("Forward Compat Core Profile 3.2 creation failure");
        }
        GLFW.glfwMakeContextCurrent((long)this.lodBuilderGlContext);
        this.lodBuilderGlCapabilities = GL.createCapabilities();
        GL_LOGGER.info("lodBuilderGlCapabilities:\n" + this.getVersionInfo(this.lodBuilderGlCapabilities), new Object[0]);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.proxyWorkerGlContext = GLFW.glfwCreateWindow((int)64, (int)48, (CharSequence)"LOD proxy worker Window", (long)0L, (long)this.minecraftGlContext);
        if (this.proxyWorkerGlContext == 0L) {
            GL_LOGGER.error("ERROR: Failed to create GLFW context for OpenGL 3.2 with Forward Compat Core Profile! Your OS may have not been able to support it!", new Object[0]);
            throw new UnsupportedOperationException("Forward Compat Core Profile 3.2 creation failure");
        }
        GLFW.glfwMakeContextCurrent((long)this.proxyWorkerGlContext);
        this.proxyWorkerGlCapabilities = GL.createCapabilities();
        GL_LOGGER.info("proxyWorkerGlCapabilities:\n" + this.getVersionInfo(this.lodBuilderGlCapabilities), new Object[0]);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.VertexAttributeBufferBindingSupported = this.minecraftGlCapabilities.glBindVertexBuffer != 0L;
        this.namedObjectSupported = this.minecraftGlCapabilities.glNamedBufferData != 0L;
        this.setGlContext(GLProxyContext.LOD_BUILDER);
        GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.lodBuilderDebugMessageBuilder), true));
        boolean bl = this.bufferStorageSupported = this.minecraftGlCapabilities.glBufferStorage != 0L && this.lodBuilderGlCapabilities.glBufferStorage != 0L;
        if (!this.bufferStorageSupported) {
            GL_LOGGER.warn("This GPU doesn't support Buffer Storage (OpenGL 4.4), falling back to using other methods.", new Object[0]);
        }
        this.preferredUploadMethod = (vendor = GL32.glGetString((int)7936).toUpperCase()).contains("NVIDIA") || vendor.contains("GEFORCE") ? (this.bufferStorageSupported ? GpuUploadMethod.BUFFER_STORAGE : GpuUploadMethod.SUB_DATA) : GpuUploadMethod.BUFFER_MAPPING;
        GL_LOGGER.info("GPU Vendor [" + vendor + "], Preferred upload method is [" + (Object)((Object)this.preferredUploadMethod) + "].", new Object[0]);
        this.setGlContext(GLProxyContext.PROXY_WORKER);
        GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.proxyWorkerDebugMessageBuilder), true));
        this.setGlContext(GLProxyContext.MINECRAFT);
        GL_LOGGER.info(GLProxy.class.getSimpleName() + " creation successful. OpenGL smiles upon you this day.", new Object[0]);
    }

    public void setGlContext(GLProxyContext newContext) {
        long contextPointer;
        GLProxyContext currentContext = this.getGlContext();
        if (currentContext == newContext) {
            return;
        }
        GLCapabilities newGlCapabilities = null;
        switch (newContext) {
            case LOD_BUILDER: {
                contextPointer = this.lodBuilderGlContext;
                newGlCapabilities = this.lodBuilderGlCapabilities;
                break;
            }
            case MINECRAFT: {
                contextPointer = this.minecraftGlContext;
                newGlCapabilities = this.minecraftGlCapabilities;
                break;
            }
            case PROXY_WORKER: {
                contextPointer = this.proxyWorkerGlContext;
                newGlCapabilities = this.proxyWorkerGlCapabilities;
                break;
            }
            default: {
                contextPointer = 0L;
            }
        }
        GLFW.glfwMakeContextCurrent((long)contextPointer);
        GL.setCapabilities((GLCapabilities)newGlCapabilities);
    }

    public GLProxyContext getGlContext() {
        long currentContext = GLFW.glfwGetCurrentContext();
        if (currentContext == this.lodBuilderGlContext) {
            return GLProxyContext.LOD_BUILDER;
        }
        if (currentContext == this.minecraftGlContext) {
            return GLProxyContext.MINECRAFT;
        }
        if (currentContext == this.proxyWorkerGlContext) {
            return GLProxyContext.PROXY_WORKER;
        }
        if (currentContext == 0L) {
            return GLProxyContext.NONE;
        }
        throw new IllegalStateException(Thread.currentThread().getName() + " has a unknown OpenGl context: [" + currentContext + "]. Minecraft context [" + this.minecraftGlContext + "], LodBuilder context [" + this.lodBuilderGlContext + "], ProxyWorker context [" + this.proxyWorkerGlContext + "], no context [0].");
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static GLProxy getInstance() {
        if (instance == null) {
            instance = new GLProxy();
        }
        return instance;
    }

    public GpuUploadMethod getGpuUploadMethod() {
        GpuUploadMethod method = CONFIG.client().advanced().buffers().getGpuUploadMethod();
        if (!this.bufferStorageSupported && method == GpuUploadMethod.BUFFER_STORAGE) {
            method = GpuUploadMethod.SUB_DATA;
        }
        return method == GpuUploadMethod.AUTO ? this.preferredUploadMethod : method;
    }

    public void recordOpenGlCall(Runnable renderCall) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.workerThread.execute(() -> this.runnableContainer(renderCall, stackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runnableContainer(Runnable renderCall, StackTraceElement[] stackTrace) {
        try {
            this.setGlContext(GLProxyContext.PROXY_WORKER);
            renderCall.run();
        }
        catch (Exception e) {
            RuntimeException error = new RuntimeException("Uncaught Exception during execution:", e);
            error.setStackTrace(stackTrace);
            GL_LOGGER.error(Thread.currentThread().getName() + " ran into a issue: ", error);
        }
        finally {
            this.setGlContext(GLProxyContext.NONE);
        }
    }

    public static void ensureAllGLJobCompleted() {
        if (!GLProxy.hasInstance()) {
            return;
        }
        ApiShared.LOGGER.info("Blocking until GL jobs finished...");
        try {
            GLProxy.instance.workerThread.shutdown();
            boolean worked = GLProxy.instance.workerThread.awaitTermination(30L, TimeUnit.SECONDS);
            if (!worked) {
                ApiShared.LOGGER.error("GLWorkerThread shutdown timed out! Game may crash on exit due to cleanup failure!");
            }
        }
        catch (InterruptedException e) {
            ApiShared.LOGGER.error("GLWorkerThread shutdown is interrupted! Game may crash on exit due to cleanup failure!");
            e.printStackTrace();
        }
        finally {
            GLProxy.instance.workerThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(GLProxy.class.getSimpleName() + "-Worker-Thread").build());
        }
        ApiShared.LOGGER.info("All GL jobs finished!");
    }
}

