/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.enums.config.HorizontalQuality;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;

public class DetailDistanceUtil {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static byte minDetail = DetailDistanceUtil.CONFIG.client().graphics().quality().getDrawResolution().detailLevel;
    private static final byte maxDetail = 10;
    private static final double minDistance = 0.0;
    private static double distanceUnit = 16 * CONFIG.client().graphics().quality().getHorizontalScale();
    private static double maxDistance = CONFIG.client().graphics().quality().getLodChunkRenderDistance() * 16 * 2;
    private static double logBase = Math.log(DetailDistanceUtil.CONFIG.client().graphics().quality().getHorizontalQuality().quadraticBase);

    public static void updateSettings() {
        distanceUnit = 16 * CONFIG.client().graphics().quality().getHorizontalScale();
        minDetail = DetailDistanceUtil.CONFIG.client().graphics().quality().getDrawResolution().detailLevel;
        maxDistance = CONFIG.client().graphics().quality().getLodChunkRenderDistance() * 16 * 8;
        logBase = Math.log(DetailDistanceUtil.CONFIG.client().graphics().quality().getHorizontalQuality().quadraticBase);
    }

    public static double baseDistanceFunction(int detail) {
        if (detail <= minDetail) {
            return 0.0;
        }
        if (detail >= 10) {
            return maxDistance;
        }
        detail -= minDetail;
        if (CONFIG.client().graphics().quality().getHorizontalQuality() == HorizontalQuality.LOWEST) {
            return (double)detail * distanceUnit;
        }
        double base = DetailDistanceUtil.CONFIG.client().graphics().quality().getHorizontalQuality().quadraticBase;
        return Math.pow(base, detail) * distanceUnit;
    }

    public static double getDrawDistanceFromDetail(int detail) {
        return DetailDistanceUtil.baseDistanceFunction(detail);
    }

    public static byte baseInverseFunction(double distance) {
        double maxDetailDistance = DetailDistanceUtil.getDrawDistanceFromDetail(9);
        if (distance > maxDetailDistance) {
            return 9;
        }
        int detail = CONFIG.client().graphics().quality().getHorizontalQuality() == HorizontalQuality.LOWEST ? (int)(distance / distanceUnit) : (int)(Math.log(distance / distanceUnit) / logBase);
        return (byte)LodUtil.clamp(minDetail, detail + minDetail, 9);
    }

    public static byte getDetailLevelFromDistance(double distance) {
        return DetailDistanceUtil.baseInverseFunction(distance);
    }

    public static int getMaxVerticalData(int detail) {
        return DetailDistanceUtil.CONFIG.client().graphics().quality().getVerticalQuality().maxVerticalData[detail];
    }
}

