/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.api.EventApi;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import forge.com.seibel.lod.common.wrappers.world.WorldWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeClientProxy {
    private final EventApi eventApi = EventApi.INSTANCE;
    private final ClientApi clientApi = ClientApi.INSTANCE;

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.eventApi.serverTickEvent();
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkEvent.Load event) {
        this.clientApi.clientChunkLoadEvent(new ChunkWrapper(event.getChunk(), (IWorldReader)event.getWorld()), WorldWrapper.getWorldWrapper(event.getWorld()));
    }

    @SubscribeEvent
    public void worldSaveEvent(WorldEvent.Save event) {
        this.eventApi.worldSaveEvent();
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen) {
            return;
        }
        if (event.getWorld() != null) {
            this.eventApi.worldLoadEvent(WorldWrapper.getWorldWrapper(event.getWorld()));
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        this.eventApi.worldUnloadEvent(WorldWrapper.getWorldWrapper(event.getWorld()));
    }

    @SubscribeEvent
    public void blockChangeEvent(BlockEvent event) {
        if (event.getClass() == BlockEvent.BreakEvent.class || event.getClass() == BlockEvent.EntityPlaceEvent.class || event.getClass() == BlockEvent.EntityMultiPlaceEvent.class || event.getClass() == BlockEvent.FluidPlaceBlockEvent.class || event.getClass() == BlockEvent.PortalSpawnEvent.class) {
            ChunkWrapper chunk = new ChunkWrapper(event.getWorld().func_217349_x(event.getPos()), (IWorldReader)event.getWorld());
            DimensionTypeWrapper dimType = DimensionTypeWrapper.getDimensionTypeWrapper(event.getWorld().func_230315_m_());
            this.eventApi.blockChangeEvent(chunk, dimType);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        this.clientApi.keyPressedEvent(event.getKey());
    }
}

