/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.seibel.lod.core.logging.ConfigBasedLogger;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1951;
import net.minecraft.class_2348;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_2850;
import net.minecraft.class_2902;
import net.minecraft.class_3568;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_4296;
import net.minecraft.class_4548;
import net.minecraft.class_5281;

public class ChunkLoader {
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;

    private static class_2826[] readSections(class_1936 level, class_3568 lightEngine, class_1923 chunkPos, class_2487 chunkData) {
        int i = 16;
        class_2826[] chunkSections = new class_2826[i];
        boolean isLightOn = chunkData.method_10577("isLightOn");
        boolean hasSkyLight = level.method_8597().method_12491();
        class_2499 tagSections = chunkData.method_10554("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.method_10554("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            class_2487 tagSection = tagSections.method_10602(j);
            byte sectionYPos = tagSection.method_10571("Y");
            if (tagSection.method_10573("Palette", 9) && tagSection.method_10573("BlockStates", 12)) {
                class_2826 levelChunkSection = new class_2826(sectionYPos << 4);
                levelChunkSection.method_12265().method_12329(tagSection.method_10554("Palette", 10), tagSection.method_10565("BlockStates"));
                levelChunkSection.method_12253();
                if (!levelChunkSection.method_12261()) {
                    chunkSections[sectionYPos] = levelChunkSection;
                }
            }
            if (!isLightOn) continue;
            if (tagSection.method_10573("BlockLight", 7)) {
                lightEngine.method_15558(class_1944.field_9282, class_4076.method_18681((class_1923)chunkPos, (int)sectionYPos), new class_2804(tagSection.method_10547("BlockLight")), true);
            }
            if (!hasSkyLight || !tagSection.method_10573("SkyLight", 7)) continue;
            lightEngine.method_15558(class_1944.field_9284, class_4076.method_18681((class_1923)chunkPos, (int)sectionYPos), new class_2804(tagSection.method_10547("SkyLight")), true);
        }
        return chunkSections;
    }

    private static void readHeightmaps(class_2818 chunk, class_2487 chunkData) {
        class_2487 tagHeightmaps = chunkData.method_10562("Heightmaps");
        for (class_2902.class_2903 type : class_2806.field_12803.method_12160()) {
            String heightmap = type.method_12605();
            if (!tagHeightmaps.method_10573(heightmap, 12)) continue;
            chunk.method_12037(type, tagHeightmaps.method_10565(heightmap));
        }
        class_2902.method_16684((class_2791)chunk, (Set)class_2806.field_12803.method_12160());
    }

    private static void readPostPocessings(class_2818 chunk, class_2487 chunkData) {
        class_2499 tagPostProcessings = chunkData.method_10554("PostProcessing", 9);
        for (int n = 0; n < tagPostProcessings.size(); ++n) {
            class_2499 listTag3 = tagPostProcessings.method_10603(n);
            for (int o = 0; o < listTag3.size(); ++o) {
                chunk.method_12029(listTag3.method_10609(o), n);
            }
        }
    }

    public static class_2806.class_2808 readChunkType(class_2487 tagLevel) {
        class_2806 chunkStatus = class_2806.method_12168((String)tagLevel.method_10558("Status"));
        if (chunkStatus != null) {
            return chunkStatus.method_12164();
        }
        return class_2806.class_2808.field_12808;
    }

    public static class_2818 read(class_5281 level, class_3568 lightEngine, class_1923 chunkPos, class_2487 chunkData) {
        class_2850 blockTicks;
        class_2487 tagLevel = chunkData.method_10562("Level");
        class_1923 actualPos = new class_1923(tagLevel.method_10550("xPos"), tagLevel.method_10550("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; Ignoring. (Expected {}, got {})", chunkPos, chunkPos, actualPos);
            return null;
        }
        class_2806.class_2808 chunkType = ChunkLoader.readChunkType(tagLevel);
        if (chunkType != class_2806.class_2808.field_12807) {
            return null;
        }
        long inhabitedTime = tagLevel.method_10537("InhabitedTime");
        class_2843 upgradeData = tagLevel.method_10573(TAG_UPGRADE_DATA, 10) ? new class_2843(tagLevel.method_10562(TAG_UPGRADE_DATA)) : class_2843.field_12950;
        boolean isLightOn = tagLevel.method_10577("isLightOn");
        if (isLightOn) {
            lightEngine.method_20601(chunkPos, true);
        }
        class_4548 chunkBiomeContainer = new class_4548((class_2359)level.method_8410().method_30349().method_30530(class_2378.field_25114), chunkPos, level.method_8410().method_14178().method_12129().method_12098(), tagLevel.method_10573("Biomes", 11) ? tagLevel.method_10561("Biomes") : null);
        Object object = tagLevel.method_10573(BLOCK_TICKS_TAG_PRE18, 9) ? class_4296.method_20512((class_2499)tagLevel.method_10554(BLOCK_TICKS_TAG_PRE18, 10), arg_0 -> ((class_2348)class_2378.field_11146).method_10221(arg_0), arg_0 -> ((class_2348)class_2378.field_11146).method_10223(arg_0)) : (blockTicks = new class_2850(block -> block == null || block.method_9564().method_26215(), chunkPos, tagLevel.method_10554("ToBeTicked", 9)));
        class_2850 fluidTicks = tagLevel.method_10573(FLUID_TICKS_TAG_PRE18, 9) ? class_4296.method_20512((class_2499)tagLevel.method_10554(FLUID_TICKS_TAG_PRE18, 10), arg_0 -> ((class_2348)class_2378.field_11154).method_10221(arg_0), arg_0 -> ((class_2348)class_2378.field_11154).method_10223(arg_0)) : new class_2850(fluid -> fluid == null || fluid == class_3612.field_15906, chunkPos, tagLevel.method_10554("LiquidsToBeTicked", 9));
        class_2826[] levelChunkSections = ChunkLoader.readSections((class_1936)level, lightEngine, chunkPos, tagLevel);
        class_2818 chunk = new class_2818((class_1937)level.method_8410(), chunkPos, chunkBiomeContainer, upgradeData, (class_1951)blockTicks, (class_1951)fluidTicks, inhabitedTime, levelChunkSections, null);
        chunk.method_12020(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static void logErrors(class_1923 chunkPos, int i, String string) {
        LOGGER.error("Distant Horizons: Recoverable errors when loading section [" + chunkPos.field_9181 + ", " + i + ", " + chunkPos.field_9180 + "]: " + string, new Object[0]);
    }
}

