/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.chunk;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import forge.com.seibel.lod.common.wrappers.WrapperUtil;
import forge.com.seibel.lod.common.wrappers.block.BlockDetailMap;
import forge.com.seibel.lod.common.wrappers.block.BlockDetailWrapper;
import forge.com.seibel.lod.common.wrappers.world.BiomeWrapper;
import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightedWorldGenRegion;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class ChunkWrapper
implements IChunkWrapper {
    private final IChunk chunk;
    private final IWorldReader lightSource;

    public ChunkWrapper(IChunk chunk, IWorldReader lightSource) {
        this.chunk = chunk;
        this.lightSource = lightSource;
    }

    @Override
    public int getHeight() {
        return 255;
    }

    @Override
    public int getMinBuildHeight() {
        return 0;
    }

    @Override
    public int getMaxBuildHeight() {
        return this.chunk.func_217301_I();
    }

    @Override
    public int getHeightMapValue(int xRel, int zRel) {
        return this.chunk.func_217303_b(WrapperUtil.DEFAULT_HEIGHTMAP).func_202273_a(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int x, int y, int z) {
        return BiomeWrapper.getBiomeWrapper(this.chunk.func_225549_i_().func_225526_b_(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public IBlockDetailWrapper getBlockDetail(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState blockState = this.chunk.func_180495_p(pos);
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    @Override
    public IBlockDetailWrapper getBlockDetailAtFace(int x, int y, int z, LodDirection dir) {
        int fy = y + dir.getNormal().y;
        if (fy < this.getMinBuildHeight() || fy > this.getMaxBuildHeight()) {
            return null;
        }
        BlockPos pos = new BlockPos(x + dir.getNormal().x, fy, z + dir.getNormal().z);
        BlockState blockState = this.blockPosInsideChunk(x, y, z) ? this.chunk.func_180495_p(pos) : this.lightSource.func_180495_p(pos);
        if (blockState == null || blockState.func_196958_f()) {
            return null;
        }
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    public IChunk getChunk() {
        return this.chunk;
    }

    @Override
    public int getChunkPosX() {
        return this.chunk.func_76632_l().field_77276_a;
    }

    @Override
    public int getChunkPosZ() {
        return this.chunk.func_76632_l().field_77275_b;
    }

    @Override
    public int getRegionPosX() {
        return LevelPosUtil.convert((byte)4, this.chunk.func_76632_l().field_77276_a, (byte)9);
    }

    @Override
    public int getRegionPosZ() {
        return LevelPosUtil.convert((byte)4, this.chunk.func_76632_l().field_77275_b, (byte)9);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, Math.floorMod(x, 16), Math.floorMod(z, 16));
    }

    @Override
    public int getMaxX() {
        return this.chunk.func_76632_l().func_180332_e();
    }

    @Override
    public int getMaxZ() {
        return this.chunk.func_76632_l().func_180330_f();
    }

    @Override
    public int getMinX() {
        return this.chunk.func_76632_l().func_180334_c();
    }

    @Override
    public int getMinZ() {
        return this.chunk.func_76632_l().func_180333_d();
    }

    @Override
    public long getLongChunkPos() {
        return this.chunk.func_76632_l().func_201841_a();
    }

    @Override
    public boolean isLightCorrect() {
        return true;
    }

    @Override
    public boolean isWaterLogged(int x, int y, int z) {
        BlockState blockState = this.chunk.func_180495_p(new BlockPos(x, y, z));
        return !(blockState.func_177230_c() instanceof ILiquidContainer) && blockState.func_177230_c() instanceof IWaterLoggable && blockState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208198_y) != false;
    }

    @Override
    public int getEmittedBrightness(int x, int y, int z) {
        return this.chunk.func_217298_h(new BlockPos(x, y, z));
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.func_226658_a_(LightType.BLOCK, new BlockPos(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.func_226658_a_(LightType.SKY, new BlockPos(x, y, z));
    }

    @Override
    public boolean doesNearbyChunksExist() {
        if (this.lightSource instanceof LightedWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.func_217353_a(dx + this.getChunkPosX(), dz + this.getChunkPosZ(), ChunkStatus.field_222608_d, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public IWorldReader getColorResolver() {
        return this.lightSource;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + this.chunk.func_76632_l();
    }
}

