/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.minecraft;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkPosWrapper;
import forge.com.seibel.lod.common.wrappers.minecraft.ProfilerWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import forge.com.seibel.lod.common.wrappers.world.WorldWrapper;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper {
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    public final Minecraft mc = Minecraft.func_71410_x();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(LodDirection lodDirection) {
        if (this.mc.field_71441_e != null) {
            Direction mcDir = McObjectConverter.Convert(lodDirection);
            return this.mc.field_71441_e.func_230487_a_(mcDir, true);
        }
        return 0.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return this.mc.func_71356_B();
    }

    @Override
    public String getCurrentServerName() {
        return this.mc.func_147104_D().field_78847_a;
    }

    @Override
    public String getCurrentServerIp() {
        return this.mc.func_147104_D().field_78845_b;
    }

    @Override
    public String getCurrentServerVersion() {
        return this.mc.func_147104_D().field_82822_g.getString();
    }

    @Override
    public IDimensionTypeWrapper getCurrentDimension() {
        if (this.mc.field_71439_g != null) {
            return DimensionTypeWrapper.getDimensionTypeWrapper(this.mc.field_71439_g.field_70170_p.func_230315_m_());
        }
        return null;
    }

    @Override
    public String getCurrentDimensionId() {
        return LodUtil.getDimensionIDFromWorld(WorldWrapper.getWorldWrapper((IWorld)this.mc.field_71441_e));
    }

    public ClientPlayerEntity getPlayer() {
        return this.mc.field_71439_g;
    }

    @Override
    public boolean playerExists() {
        return this.mc.field_71439_g != null;
    }

    @Override
    public BlockPosWrapper getPlayerBlockPos() {
        BlockPos playerPos = this.getPlayer().func_233580_cy_();
        return new BlockPosWrapper(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p());
    }

    @Override
    public ChunkPosWrapper getPlayerChunkPos() {
        ChunkPos playerPos = new ChunkPos(this.getPlayer().func_233580_cy_());
        return new ChunkPosWrapper(playerPos.field_77276_a, playerPos.field_77275_b);
    }

    public GameSettings getOptions() {
        return this.mc.field_71474_y;
    }

    public ModelManager getModelManager() {
        return this.mc.func_209506_al();
    }

    public ClientWorld getClientLevel() {
        return this.mc.field_71441_e;
    }

    @Override
    public IWorldWrapper getWrappedServerWorld() {
        if (this.mc.field_71441_e == null) {
            return null;
        }
        DimensionType dimension = this.mc.field_71441_e.func_230315_m_();
        IntegratedServer server = this.mc.func_71401_C();
        if (server == null) {
            return null;
        }
        ServerWorld serverWorld = null;
        Iterable worlds = server.func_212370_w();
        for (ServerWorld world : worlds) {
            if (world.func_230315_m_() != dimension) continue;
            serverWorld = world;
            break;
        }
        return WorldWrapper.getWorldWrapper(serverWorld);
    }

    public WorldWrapper getWrappedClientLevel() {
        return WorldWrapper.getWorldWrapper((IWorld)this.mc.field_71441_e);
    }

    public WorldWrapper getWrappedServerLevel() {
        if (this.mc.field_71441_e == null) {
            return null;
        }
        DimensionType dimension = this.mc.field_71441_e.func_230315_m_();
        IntegratedServer server = this.mc.func_71401_C();
        if (server == null) {
            return null;
        }
        Iterable worlds = server.func_212370_w();
        ServerWorld returnWorld = null;
        for (ServerWorld world : worlds) {
            if (world.func_230315_m_() != dimension) continue;
            returnWorld = world;
            break;
        }
        return WorldWrapper.getWorldWrapper(returnWorld);
    }

    @Override
    @Nullable
    public IWorldWrapper getWrappedClientWorld() {
        return WorldWrapper.getWorldWrapper((IWorld)this.mc.field_71441_e);
    }

    @Override
    public File getGameDirectory() {
        return this.mc.field_71412_D;
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(this.mc.func_213239_aq());
        } else if (this.mc.func_213239_aq() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = this.mc.func_213239_aq();
        }
        return this.profilerWrapper;
    }

    public ClientPlayNetHandler getConnection() {
        return this.mc.func_147114_u();
    }

    public GameRenderer getGameRenderer() {
        return this.mc.field_71460_t;
    }

    public Entity getCameraEntity() {
        return this.mc.field_175622_Z;
    }

    public MainWindow getWindow() {
        return this.mc.func_228018_at_();
    }

    @Override
    public float getSkyDarken(float partialTicks) {
        return this.mc.field_71441_e.func_228326_g_(partialTicks);
    }

    public IntegratedServer getSinglePlayerServer() {
        return this.mc.func_71401_C();
    }

    @Override
    public boolean connectedToServer() {
        return this.mc.func_147104_D() != null;
    }

    @Override
    public int getPlayerSkylight() {
        if (this.mc.field_71441_e == null) {
            return -1;
        }
        if (this.mc.field_71439_g == null) {
            return -1;
        }
        if (this.mc.field_71439_g.func_233580_cy_() == null) {
            return -1;
        }
        return this.mc.field_71441_e.func_226658_a_(LightType.SKY, this.mc.field_71439_g.func_233580_cy_());
    }

    public ServerData getCurrentServer() {
        return this.mc.func_147104_D();
    }

    public WorldRenderer getLevelRenderer() {
        return this.mc.field_71438_f;
    }

    @Override
    public ArrayList<IWorldWrapper> getAllServerWorlds() {
        ArrayList<IWorldWrapper> worlds = new ArrayList<IWorldWrapper>();
        Iterable serverWorlds = this.mc.func_71401_C().func_212370_w();
        for (ServerWorld world : serverWorlds) {
            worlds.add(WorldWrapper.getWorldWrapper((IWorld)world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        this.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(string), this.getPlayer().func_110124_au());
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        ApiShared.LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...");
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.func_71377_b((CrashReport)report);
    }
}

