/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.world;

import com.seibel.lod.core.enums.WorldType;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class WorldWrapper
implements IWorldWrapper {
    private static final ConcurrentMap<IWorld, WorldWrapper> worldWrapperMap = new ConcurrentHashMap<IWorld, WorldWrapper>();
    private final IWorld world;
    public final WorldType worldType;

    public WorldWrapper(IWorld newWorld) {
        this.world = newWorld;
        this.worldType = this.world.getClass() == ServerWorld.class ? WorldType.ServerWorld : (this.world.getClass() == ClientWorld.class ? WorldType.ClientWorld : WorldType.Unknown);
    }

    @Nullable
    public static WorldWrapper getWorldWrapper(IWorld world) {
        if (world == null) {
            return null;
        }
        if (worldWrapperMap.containsKey(world) && worldWrapperMap.get(world) != null) {
            return (WorldWrapper)worldWrapperMap.get(world);
        }
        WorldWrapper worldWrapper = new WorldWrapper(world);
        worldWrapperMap.put(world, worldWrapper);
        return worldWrapper;
    }

    public static void clearMap() {
        worldWrapperMap.clear();
    }

    @Override
    public WorldType getWorldType() {
        return this.worldType;
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.world.func_230315_m_());
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.world.func_226658_a_(LightType.BLOCK, new BlockPos(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.world.func_226658_a_(LightType.SKY, new BlockPos(x, y, z));
    }

    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public boolean hasCeiling() {
        return this.world.func_230315_m_().func_236037_d_();
    }

    @Override
    public boolean hasSkyLight() {
        return this.world.func_230315_m_().func_218272_d();
    }

    @Override
    public int getHeight() {
        return this.world.func_234938_ad_();
    }

    @Override
    public short getMinHeight() {
        return 0;
    }

    @Override
    public File getSaveFolder() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        ServerChunkProvider chunkSource = ((ServerWorld)this.world).func_72863_F();
        return chunkSource.func_217227_h().field_215759_d;
    }

    public ServerWorld getServerWorld() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        return (ServerWorld)this.world;
    }

    @Override
    public int getSeaLevel() {
        return this.world.func_181545_F();
    }

    @Override
    public IChunkWrapper tryGetChunk(AbstractChunkPosWrapper pos) {
        IChunk chunk = this.world.func_217353_a(pos.getX(), pos.getZ(), ChunkStatus.field_223226_a_, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (IWorldReader)this.world);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        AbstractChunkProvider source = this.world.func_72863_F();
        return source.func_73149_a(chunkX, chunkZ);
    }
}

